/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.capnproto.Arena;
import org.capnproto.DecodeException;
import org.capnproto.SegmentReader;

public final class ReaderArena
implements Arena {
    public long limit;
    public final ArrayList<SegmentReader> segments;

    public ReaderArena(ByteBuffer[] segmentSlices, long traversalLimitInWords) {
        this.limit = traversalLimitInWords;
        this.segments = new ArrayList(segmentSlices.length);
        for (int ii = 0; ii < segmentSlices.length; ++ii) {
            this.segments.add(new SegmentReader(segmentSlices[ii], this));
        }
    }

    @Override
    public SegmentReader tryGetSegment(int id) {
        return this.segments.get(id);
    }

    @Override
    public final void checkReadLimit(int numWords) {
        if (this.limit == -1L) {
            return;
        }
        if ((long)numWords > this.limit) {
            throw new DecodeException("Read limit exceeded.");
        }
        this.limit -= (long)numWords;
    }
}

