/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerReader;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.FromPointerReaderRefDefault;
import org.capnproto.SegmentReader;

public class StructReader {
    protected final SegmentReader segment;
    protected final int data;
    protected final int pointers;
    protected final int dataSize;
    protected final short pointerCount;
    protected final int nestingLimit;

    public StructReader() {
        this.segment = SegmentReader.EMPTY;
        this.data = 0;
        this.pointers = 0;
        this.dataSize = 0;
        this.pointerCount = 0;
        this.nestingLimit = Integer.MAX_VALUE;
    }

    public StructReader(SegmentReader segment, int data, int pointers, int dataSize, short pointerCount, int nestingLimit) {
        this.segment = segment;
        this.data = data;
        this.pointers = pointers;
        this.dataSize = dataSize;
        this.pointerCount = pointerCount;
        this.nestingLimit = nestingLimit;
    }

    protected final boolean _getBooleanField(int offset) {
        if (offset < this.dataSize) {
            byte b = this.segment.buffer.get(this.data + offset / 8);
            return (b & 1 << offset % 8) != 0;
        }
        return false;
    }

    protected final boolean _getBooleanField(int offset, boolean mask) {
        return this._getBooleanField(offset) ^ mask;
    }

    protected final byte _getByteField(int offset) {
        if ((offset + 1) * 8 <= this.dataSize) {
            return this.segment.buffer.get(this.data + offset);
        }
        return 0;
    }

    protected final byte _getByteField(int offset, byte mask) {
        return (byte)(this._getByteField(offset) ^ mask);
    }

    protected final short _getShortField(int offset) {
        if ((offset + 1) * 16 <= this.dataSize) {
            return this.segment.buffer.getShort(this.data + offset * 2);
        }
        return 0;
    }

    protected final short _getShortField(int offset, short mask) {
        return (short)(this._getShortField(offset) ^ mask);
    }

    protected final int _getIntField(int offset) {
        if ((offset + 1) * 32 <= this.dataSize) {
            return this.segment.buffer.getInt(this.data + offset * 4);
        }
        return 0;
    }

    protected final int _getIntField(int offset, int mask) {
        return this._getIntField(offset) ^ mask;
    }

    protected final long _getLongField(int offset) {
        if ((offset + 1) * 64 <= this.dataSize) {
            return this.segment.buffer.getLong(this.data + offset * 8);
        }
        return 0L;
    }

    protected final long _getLongField(int offset, long mask) {
        return this._getLongField(offset) ^ mask;
    }

    protected final float _getFloatField(int offset) {
        if ((offset + 1) * 32 <= this.dataSize) {
            return this.segment.buffer.getFloat(this.data + offset * 4);
        }
        return 0.0f;
    }

    protected final float _getFloatField(int offset, int mask) {
        if ((offset + 1) * 32 <= this.dataSize) {
            return Float.intBitsToFloat(this.segment.buffer.getInt(this.data + offset * 4) ^ mask);
        }
        return Float.intBitsToFloat(mask);
    }

    protected final double _getDoubleField(int offset) {
        if ((offset + 1) * 64 <= this.dataSize) {
            return this.segment.buffer.getDouble(this.data + offset * 8);
        }
        return 0.0;
    }

    protected final double _getDoubleField(int offset, long mask) {
        if ((offset + 1) * 64 <= this.dataSize) {
            return Double.longBitsToDouble(this.segment.buffer.getLong(this.data + offset * 8) ^ mask);
        }
        return Double.longBitsToDouble(mask);
    }

    protected final boolean _pointerFieldIsNull(int ptrIndex) {
        return ptrIndex >= this.pointerCount || this.segment.buffer.getLong((this.pointers + ptrIndex) * 8) == 0L;
    }

    protected final <T> T _getPointerField(FromPointerReader<T> factory, int ptrIndex) {
        if (ptrIndex < this.pointerCount) {
            return factory.fromPointerReader(this.segment, this.pointers + ptrIndex, this.nestingLimit);
        }
        return factory.fromPointerReader(SegmentReader.EMPTY, 0, this.nestingLimit);
    }

    protected final <T> T _getPointerField(FromPointerReaderRefDefault<T> factory, int ptrIndex, SegmentReader defaultSegment, int defaultOffset) {
        if (ptrIndex < this.pointerCount) {
            return factory.fromPointerReaderRefDefault(this.segment, this.pointers + ptrIndex, defaultSegment, defaultOffset, this.nestingLimit);
        }
        return factory.fromPointerReaderRefDefault(SegmentReader.EMPTY, 0, defaultSegment, defaultOffset, this.nestingLimit);
    }

    protected final <T> T _getPointerField(FromPointerReaderBlobDefault<T> factory, int ptrIndex, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
        if (ptrIndex < this.pointerCount) {
            return factory.fromPointerReaderBlobDefault(this.segment, this.pointers + ptrIndex, defaultBuffer, defaultOffset, defaultSize);
        }
        return factory.fromPointerReaderBlobDefault(SegmentReader.EMPTY, 0, defaultBuffer, defaultOffset, defaultSize);
    }

    public static interface Factory<T> {
        public T constructReader(SegmentReader var1, int var2, int var3, int var4, short var5, int var6);
    }
}

