/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.capnproto.BufferedInputStream;

public final class ArrayInputStream
implements BufferedInputStream {
    public final ByteBuffer buf;

    public ArrayInputStream(ByteBuffer buf) {
        this.buf = buf.asReadOnlyBuffer();
    }

    public final int read(ByteBuffer dst) throws IOException {
        int available = this.buf.remaining();
        int size = Math.min(dst.remaining(), available);
        if (size == 0) {
            return -1;
        }
        ByteBuffer slice = this.buf.slice();
        slice.limit(size);
        dst.put(slice);
        this.buf.position(this.buf.position() + size);
        return size;
    }

    public final ByteBuffer getReadBuffer() {
        return this.buf;
    }

    public final void close() throws IOException {
    }

    public final boolean isOpen() {
        return true;
    }
}

