/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.Allocator;
import org.capnproto.AnyPointer;
import org.capnproto.BuilderArena;
import org.capnproto.DefaultAllocator;
import org.capnproto.FromPointerBuilder;
import org.capnproto.SegmentBuilder;
import org.capnproto.SetPointerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageBuilder {
    private final BuilderArena arena;

    public MessageBuilder() {
        this.arena = new BuilderArena(1024, BuilderArena.SUGGESTED_ALLOCATION_STRATEGY);
    }

    public MessageBuilder(int firstSegmentWords) {
        this.arena = new BuilderArena(firstSegmentWords, BuilderArena.SUGGESTED_ALLOCATION_STRATEGY);
    }

    public MessageBuilder(int firstSegmentWords, BuilderArena.AllocationStrategy allocationStrategy) {
        this.arena = new BuilderArena(firstSegmentWords, allocationStrategy);
    }

    public MessageBuilder(Allocator allocator) {
        this.arena = new BuilderArena(allocator);
    }

    public MessageBuilder(Allocator allocator, ByteBuffer firstSegment) {
        this.arena = new BuilderArena(allocator, firstSegment);
    }

    public MessageBuilder(ByteBuffer firstSegment) {
        this.arena = new BuilderArena(new DefaultAllocator(), firstSegment);
    }

    private AnyPointer.Builder getRootInternal() {
        SegmentBuilder rootSegment;
        if (this.arena.segments.isEmpty()) {
            this.arena.allocate(1);
        }
        if ((rootSegment = this.arena.segments.get(0)).currentSize() == 0) {
            int location = rootSegment.allocate(1);
            if (location == -1) {
                throw new RuntimeException("could not allocate root pointer");
            }
            if (location != 0) {
                throw new RuntimeException("First allocated word of new segment was not at offset 0");
            }
            return new AnyPointer.Builder(rootSegment, location);
        }
        return new AnyPointer.Builder(rootSegment, 0);
    }

    public <T> T getRoot(FromPointerBuilder<T> factory) {
        return this.getRootInternal().getAs(factory);
    }

    public <T, U> void setRoot(SetPointerBuilder<T, U> factory, U reader) {
        this.getRootInternal().setAs(factory, reader);
    }

    public <T> T initRoot(FromPointerBuilder<T> factory) {
        return this.getRootInternal().initAs(factory);
    }

    public final ByteBuffer[] getSegmentsForOutput() {
        return this.arena.getSegmentsForOutput();
    }

    public final void clearFirstSegment() {
        this.arena.segments.get(0).clear();
    }
}

