/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.Arena;
import org.capnproto.BuilderArena;
import org.capnproto.SegmentReader;

public final class SegmentBuilder
extends SegmentReader {
    public static final int FAILED_ALLOCATION = -1;
    public int pos = 0;
    public int id = 0;

    public SegmentBuilder(ByteBuffer buf, Arena arena) {
        super(buf, arena);
    }

    private final int capacity() {
        this.buffer.rewind();
        return this.buffer.remaining() / 8;
    }

    public final int currentSize() {
        return this.pos;
    }

    public final int allocate(int amount) {
        assert (amount >= 0) : "tried to allocate a negative number of words";
        if (amount > this.capacity() - this.currentSize()) {
            return -1;
        }
        int result = this.pos;
        this.pos += amount;
        return result;
    }

    public final BuilderArena getArena() {
        return (BuilderArena)this.arena;
    }

    public final boolean isWritable() {
        return true;
    }

    public final void put(int index, long value) {
        this.buffer.putLong(index * 8, value);
    }

    public final void clear() {
        for (int ii = 0; ii < this.pos; ++ii) {
            this.put(ii, 0L);
        }
        this.pos = 0;
    }
}

