/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import org.capnproto.DecodeException;
import org.capnproto.MessageBuilder;
import org.capnproto.MessageReader;
import org.capnproto.ReaderOptions;

public final class Serialize {
    static ByteBuffer makeByteBuffer(int bytes) {
        ByteBuffer result = ByteBuffer.allocate(bytes);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.mark();
        return result;
    }

    public static void fillBuffer(ByteBuffer buffer, ReadableByteChannel bc) throws IOException {
        while (buffer.hasRemaining()) {
            int r = bc.read(buffer);
            if (r < 0) {
                throw new IOException("premature EOF");
            }
            if (r != 0) continue;
            throw new IOException("Read zero bytes. Is the channel in non-blocking mode?");
        }
    }

    public static MessageReader read(ReadableByteChannel bc) throws IOException {
        return Serialize.read(bc, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ReadableByteChannel bc, ReaderOptions options) throws IOException {
        ByteBuffer firstWord = Serialize.makeByteBuffer(8);
        Serialize.fillBuffer(firstWord, bc);
        int segmentCount = 1 + firstWord.getInt(0);
        int segment0Size = 0;
        if (segmentCount > 0) {
            segment0Size = firstWord.getInt(4);
        }
        int totalWords = segment0Size;
        if (segmentCount > 512) {
            throw new IOException("too many segments");
        }
        ArrayList<Integer> moreSizes = new ArrayList<Integer>();
        if (segmentCount > 1) {
            ByteBuffer moreSizesRaw = Serialize.makeByteBuffer(4 * (segmentCount & 0xFFFFFFFE));
            Serialize.fillBuffer(moreSizesRaw, bc);
            for (int ii = 0; ii < segmentCount - 1; ++ii) {
                int size = moreSizesRaw.getInt(ii * 4);
                moreSizes.add(size);
                totalWords += size;
            }
        }
        if ((long)totalWords > options.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        ByteBuffer allSegments = Serialize.makeByteBuffer(totalWords * 8);
        Serialize.fillBuffer(allSegments, bc);
        ByteBuffer[] segmentSlices = new ByteBuffer[segmentCount];
        allSegments.rewind();
        segmentSlices[0] = allSegments.slice();
        segmentSlices[0].limit(segment0Size * 8);
        segmentSlices[0].order(ByteOrder.LITTLE_ENDIAN);
        int offset = segment0Size;
        for (int ii = 1; ii < segmentCount; ++ii) {
            allSegments.position(offset * 8);
            segmentSlices[ii] = allSegments.slice();
            segmentSlices[ii].limit((Integer)moreSizes.get(ii - 1) * 8);
            segmentSlices[ii].order(ByteOrder.LITTLE_ENDIAN);
            offset += ((Integer)moreSizes.get(ii - 1)).intValue();
        }
        return new MessageReader(segmentSlices, options);
    }

    public static MessageReader read(ByteBuffer bb) throws IOException {
        return Serialize.read(bb, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(ByteBuffer bb, ReaderOptions options) throws IOException {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int segmentCount = 1 + bb.getInt();
        if (segmentCount > 512) {
            throw new IOException("too many segments");
        }
        ByteBuffer[] segmentSlices = new ByteBuffer[segmentCount];
        int segmentSizesBase = bb.position();
        int segmentSizesSize = segmentCount * 4;
        int align = 7;
        int segmentBase = segmentSizesBase + segmentSizesSize + align & ~align;
        int totalWords = 0;
        for (int ii = 0; ii < segmentCount; ++ii) {
            int segmentSize = bb.getInt(segmentSizesBase + ii * 4);
            bb.position(segmentBase + totalWords * 8);
            segmentSlices[ii] = bb.slice();
            segmentSlices[ii].limit(segmentSize * 8);
            segmentSlices[ii].order(ByteOrder.LITTLE_ENDIAN);
            totalWords += segmentSize;
        }
        bb.position(segmentBase + totalWords * 8);
        if ((long)totalWords > options.traversalLimitInWords) {
            throw new DecodeException("Message size exceeds traversal limit.");
        }
        return new MessageReader(segmentSlices, options);
    }

    public static long computeSerializedSizeInWords(MessageBuilder message) {
        ByteBuffer[] segments = message.getSegmentsForOutput();
        long bytes = 0L;
        bytes += 4L;
        if ((bytes += (long)(segments.length * 4)) % 8L != 0L) {
            bytes += 4L;
        }
        for (int i = 0; i < segments.length; ++i) {
            ByteBuffer s = segments[i];
            bytes += (long)s.limit();
        }
        return bytes / 8L;
    }

    public static void write(WritableByteChannel outputChannel, MessageBuilder message) throws IOException {
        ByteBuffer[] segments = message.getSegmentsForOutput();
        int tableSize = segments.length + 2 & 0xFFFFFFFE;
        ByteBuffer table = ByteBuffer.allocate(4 * tableSize);
        table.order(ByteOrder.LITTLE_ENDIAN);
        table.putInt(0, segments.length - 1);
        for (int i = 0; i < segments.length; ++i) {
            table.putInt(4 * (i + 1), segments[i].limit() / 8);
        }
        while (table.hasRemaining()) {
            outputChannel.write(table);
        }
        for (ByteBuffer buffer : segments) {
            while (buffer.hasRemaining()) {
                outputChannel.write(buffer);
            }
        }
    }
}

