/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.capnproto.BufferedInputStream;
import org.capnproto.BufferedInputStreamWrapper;
import org.capnproto.BufferedOutputStream;
import org.capnproto.BufferedOutputStreamWrapper;
import org.capnproto.MessageBuilder;
import org.capnproto.MessageReader;
import org.capnproto.PackedInputStream;
import org.capnproto.PackedOutputStream;
import org.capnproto.ReaderOptions;
import org.capnproto.Serialize;

public final class SerializePacked {
    public static MessageReader read(BufferedInputStream input) throws IOException {
        return SerializePacked.read(input, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader read(BufferedInputStream input, ReaderOptions options) throws IOException {
        PackedInputStream packedInput = new PackedInputStream(input);
        return Serialize.read(packedInput, options);
    }

    public static MessageReader readFromUnbuffered(ReadableByteChannel input) throws IOException {
        return SerializePacked.readFromUnbuffered(input, ReaderOptions.DEFAULT_READER_OPTIONS);
    }

    public static MessageReader readFromUnbuffered(ReadableByteChannel input, ReaderOptions options) throws IOException {
        PackedInputStream packedInput = new PackedInputStream(new BufferedInputStreamWrapper(input));
        return Serialize.read(packedInput, options);
    }

    public static void write(BufferedOutputStream output, MessageBuilder message) throws IOException {
        PackedOutputStream packedOutputStream = new PackedOutputStream(output);
        Serialize.write(packedOutputStream, message);
    }

    public static void writeToUnbuffered(WritableByteChannel output, MessageBuilder message) throws IOException {
        BufferedOutputStreamWrapper buffered = new BufferedOutputStreamWrapper(output);
        SerializePacked.write(buffered, message);
        buffered.flush();
    }
}

