/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.capnproto.FromPointerBuilderBlobDefault;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.PointerFactory;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;
import org.capnproto.SetPointerBuilder;
import org.capnproto.WireHelpers;

public final class Text {
    public static final Factory factory = new Factory();

    public static final class Builder {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Builder() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Builder(ByteBuffer buffer, int offset, int size) {
            this.buffer = buffer;
            this.offset = offset;
            this.size = size;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer dup = this.buffer.duplicate();
            dup.position(this.offset);
            ByteBuffer result = dup.slice();
            result.limit(this.size);
            return result;
        }

        public final String toString() {
            byte[] bytes = new byte[this.size];
            ByteBuffer dup = this.buffer.duplicate();
            dup.position(this.offset);
            dup.get(bytes, 0, this.size);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    public static final class Reader {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Reader() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Reader(ByteBuffer buffer, int offset, int size) {
            this.buffer = buffer;
            this.offset = offset * 8;
            this.size = size;
        }

        public Reader(String value) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            this.buffer = ByteBuffer.wrap(bytes);
            this.offset = 0;
            this.size = bytes.length;
        }

        public final int size() {
            return this.size;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer dup = this.buffer.asReadOnlyBuffer();
            dup.position(this.offset);
            ByteBuffer result = dup.slice();
            result.limit(this.size);
            return result;
        }

        public final String toString() {
            byte[] bytes = new byte[this.size];
            ByteBuffer dup = this.buffer.duplicate();
            dup.position(this.offset);
            dup.get(bytes, 0, this.size);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    implements FromPointerReaderBlobDefault<Reader>,
    FromPointerBuilderBlobDefault<Builder>,
    PointerFactory<Builder, Reader>,
    SetPointerBuilder<Builder, Reader> {
        @Override
        public final Reader fromPointerReaderBlobDefault(SegmentReader segment, int pointer, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
            return WireHelpers.readTextPointer(segment, pointer, defaultBuffer, defaultOffset, defaultSize);
        }

        @Override
        public final Reader fromPointerReader(SegmentReader segment, int pointer, int nestingLimit) {
            return WireHelpers.readTextPointer(segment, pointer, null, 0, 0);
        }

        @Override
        public final Builder fromPointerBuilderBlobDefault(SegmentBuilder segment, int pointer, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
            return WireHelpers.getWritableTextPointer(pointer, segment, defaultBuffer, defaultOffset, defaultSize);
        }

        @Override
        public final Builder fromPointerBuilder(SegmentBuilder segment, int pointer) {
            return WireHelpers.getWritableTextPointer(pointer, segment, null, 0, 0);
        }

        @Override
        public final Builder initFromPointerBuilder(SegmentBuilder segment, int pointer, int size) {
            return WireHelpers.initTextPointer(pointer, segment, size);
        }

        @Override
        public final void setPointerBuilder(SegmentBuilder segment, int pointer, Reader value) {
            WireHelpers.setTextPointer(pointer, segment, value);
        }
    }
}

