/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;

final class WirePointer {
    public static final byte STRUCT = 0;
    public static final byte LIST = 1;
    public static final byte FAR = 2;
    public static final byte OTHER = 3;

    WirePointer() {
    }

    public static boolean isNull(long wirePointer) {
        return wirePointer == 0L;
    }

    public static int offsetAndKind(long wirePointer) {
        return (int)(wirePointer & 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte kind(long wirePointer) {
        return (byte)(WirePointer.offsetAndKind(wirePointer) & 3);
    }

    public static int target(int offset, long wirePointer) {
        return offset + 1 + (WirePointer.offsetAndKind(wirePointer) >>> 2);
    }

    public static void setKindAndTarget(ByteBuffer buffer, int offset, byte kind, int targetOffset) {
        buffer.putInt(offset * 8, targetOffset - offset - 1 << 2 | kind);
    }

    public static void setKindWithZeroOffset(ByteBuffer buffer, int offset, byte kind) {
        buffer.putInt(offset * 8, kind);
    }

    public static void setKindAndTargetForEmptyStruct(ByteBuffer buffer, int offset) {
        buffer.putInt(offset * 8, -4);
    }

    public static void setOffsetAndKind(ByteBuffer buffer, int offset, int offsetAndKind) {
        buffer.putInt(offset * 8, offsetAndKind);
    }

    public static int inlineCompositeListElementCount(long wirePointer) {
        return WirePointer.offsetAndKind(wirePointer) >>> 2;
    }

    public static void setKindAndInlineCompositeListElementCount(ByteBuffer buffer, int offset, byte kind, int elementCount) {
        buffer.putInt(offset * 8, elementCount << 2 | kind);
    }

    public static int upper32Bits(long wirePointer) {
        return (int)(wirePointer >>> 32);
    }
}

