/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.rewards.calculation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cardanofoundation.rewards.calculation.PoolRewardsCalculation;
import org.cardanofoundation.rewards.calculation.TreasuryCalculation;
import org.cardanofoundation.rewards.calculation.config.NetworkConfig;
import org.cardanofoundation.rewards.calculation.domain.Delegator;
import org.cardanofoundation.rewards.calculation.domain.Epoch;
import org.cardanofoundation.rewards.calculation.domain.EpochCalculationResult;
import org.cardanofoundation.rewards.calculation.domain.MirCertificate;
import org.cardanofoundation.rewards.calculation.domain.PoolRewardCalculationResult;
import org.cardanofoundation.rewards.calculation.domain.PoolState;
import org.cardanofoundation.rewards.calculation.domain.ProtocolParameters;
import org.cardanofoundation.rewards.calculation.domain.RetiredPool;
import org.cardanofoundation.rewards.calculation.domain.TreasuryCalculationResult;
import org.cardanofoundation.rewards.calculation.enums.MirPot;
import org.cardanofoundation.rewards.calculation.util.BigNumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpochCalculation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EpochCalculation.class);

    public static EpochCalculationResult calculateEpochRewardPots(int epoch, BigInteger reserveInPreviousEpoch, BigInteger treasuryInPreviousEpoch, ProtocolParameters protocolParameters, Epoch epochInfo, Set<RetiredPool> retiredPools, HashSet<String> deregisteredAccounts, List<MirCertificate> mirCertificates, List<String> poolsThatProducedBlocksInEpoch, List<PoolState> poolHistories, HashSet<String> lateDeregisteredAccounts, HashSet<String> registeredAccountsSinceLastEpoch, HashSet<String> registeredAccountsUntilNow, HashSet<String> sharedPoolRewardAddressesWithoutReward, HashSet<String> deregisteredAccountsOnEpochBoundary, NetworkConfig networkConfig) {
        EpochCalculationResult epochCalculationResult = EpochCalculationResult.builder().epoch(epoch).build();
        if (epoch < networkConfig.getShelleyStartEpoch()) {
            log.warn("Epoch " + epoch + " is before the start of the Shelley era. No rewards were calculated in this epoch.");
            epochCalculationResult.setReserves(BigInteger.ZERO);
            epochCalculationResult.setTreasury(BigInteger.ZERO);
            epochCalculationResult.setTotalDistributedRewards(BigInteger.ZERO);
            epochCalculationResult.setTotalRewardsPot(BigInteger.ZERO);
            epochCalculationResult.setTotalPoolRewardsPot(BigInteger.ZERO);
            epochCalculationResult.setTotalAdaInCirculation(BigInteger.ZERO);
            return epochCalculationResult;
        }
        if (epoch == networkConfig.getShelleyStartEpoch()) {
            epochCalculationResult.setReserves(networkConfig.getShelleyInitialReserves());
            epochCalculationResult.setTreasury(networkConfig.getShelleyInitialTreasury());
            epochCalculationResult.setTotalDistributedRewards(BigInteger.ZERO);
            epochCalculationResult.setTotalRewardsPot(BigInteger.ZERO);
            epochCalculationResult.setTotalPoolRewardsPot(BigInteger.ZERO);
            epochCalculationResult.setTotalAdaInCirculation(networkConfig.getShelleyInitialUtxo());
            return epochCalculationResult;
        }
        BigInteger totalFeesForCurrentEpoch = BigInteger.ZERO;
        int totalBlocksInEpoch = 0;
        BigDecimal treasuryGrowthRate = protocolParameters.getTreasuryGrowRate();
        BigDecimal monetaryExpandRate = protocolParameters.getMonetaryExpandRate();
        BigDecimal decentralizationParameter = protocolParameters.getDecentralisation();
        BigInteger activeStakeInEpoch = BigInteger.ZERO;
        if (epochInfo != null) {
            activeStakeInEpoch = epochInfo.getActiveStake();
            totalFeesForCurrentEpoch = epochInfo.getFees() != null ? epochInfo.getFees() : BigInteger.ZERO;
            totalBlocksInEpoch = epochInfo.getBlockCount();
            if (BigNumberUtils.isLower(decentralizationParameter, BigDecimal.valueOf(0.8)) && BigNumberUtils.isHigher(decentralizationParameter, BigDecimal.ZERO)) {
                totalBlocksInEpoch = epochInfo.getNonOBFTBlockCount();
            }
        }
        int blocksInEpoch = totalBlocksInEpoch;
        BigInteger rewardPot = TreasuryCalculation.calculateTotalRewardPotWithEta(monetaryExpandRate, totalBlocksInEpoch, decentralizationParameter, reserveInPreviousEpoch, totalFeesForCurrentEpoch, networkConfig);
        BigInteger treasuryCut = BigNumberUtils.multiplyAndFloor(rewardPot, treasuryGrowthRate);
        BigInteger treasuryForCurrentEpoch = treasuryInPreviousEpoch.add(treasuryCut);
        BigInteger stakePoolRewardsPot = rewardPot.subtract(treasuryCut);
        BigInteger unclaimedRefunds = BigInteger.ZERO;
        Set rewardAddressesOfRetiredPools = retiredPools.stream().map(retiredPool -> retiredPool.getRewardAddress()).collect(Collectors.toSet());
        if (rewardAddressesOfRetiredPools.size() > 0) {
            List<String> deregisteredOwnerAccounts = deregisteredAccountsOnEpochBoundary.stream().filter(rewardAddressesOfRetiredPools::contains).toList();
            List<String> ownerAccountsRegisteredInThePast = registeredAccountsUntilNow.stream().filter(rewardAddressesOfRetiredPools::contains).toList();
            for (RetiredPool retiredPool2 : retiredPools) {
                if (!deregisteredOwnerAccounts.contains(retiredPool2.getRewardAddress()) && ownerAccountsRegisteredInThePast.contains(retiredPool2.getRewardAddress())) continue;
                BigInteger depositAmount = BigInteger.valueOf(500000000L);
                if (retiredPool2.getDepositAmount() != null) {
                    depositAmount = retiredPool2.getDepositAmount();
                }
                treasuryForCurrentEpoch = treasuryForCurrentEpoch.add(depositAmount);
                unclaimedRefunds = unclaimedRefunds.add(depositAmount);
            }
        }
        BigInteger treasuryWithdrawals = BigInteger.ZERO;
        BigInteger calculatedReserve = BigNumberUtils.subtract(reserveInPreviousEpoch, BigNumberUtils.subtract(rewardPot, totalFeesForCurrentEpoch));
        for (MirCertificate mirCertificate : mirCertificates) {
            if (mirCertificate.getPot() == MirPot.TREASURY) {
                treasuryWithdrawals = treasuryWithdrawals.add(mirCertificate.getTotalRewards());
                continue;
            }
            if (mirCertificate.getPot() != MirPot.RESERVES) continue;
            calculatedReserve = calculatedReserve.subtract(mirCertificate.getTotalRewards());
        }
        treasuryForCurrentEpoch = treasuryForCurrentEpoch.subtract(treasuryWithdrawals);
        BigInteger totalDistributedRewards = BigInteger.ZERO;
        BigInteger adaInCirculation = networkConfig.getTotalLovelace().subtract(reserveInPreviousEpoch);
        ArrayList<PoolRewardCalculationResult> poolRewardCalculationResults = new ArrayList<PoolRewardCalculationResult>();
        BigInteger unspendableEarnedRewards = BigInteger.ZERO;
        int i = 1;
        for (String poolId : poolsThatProducedBlocksInEpoch) {
            log.debug("[" + i + " / " + poolsThatProducedBlocksInEpoch.size() + "] Processing pool: " + poolId);
            PoolState poolState = poolHistories.stream().filter(history -> history.getPoolId().equals(poolId)).findFirst().orElse(null);
            PoolRewardCalculationResult poolRewardCalculationResult = PoolRewardCalculationResult.builder().poolId(poolId).epoch(epoch).poolReward(BigInteger.ZERO).build();
            if (poolState != null) {
                HashSet<String> stakeAddresses = new HashSet<String>();
                stakeAddresses.add(poolState.getRewardAddress());
                stakeAddresses.addAll(poolState.getDelegators().stream().map(Delegator::getStakeAddress).toList());
                HashSet delegatorAccountDeregistrations = deregisteredAccounts.stream().filter(stakeAddresses::contains).collect(Collectors.toCollection(HashSet::new));
                HashSet lateDeregisteredDelegators = lateDeregisteredAccounts.stream().filter(stakeAddresses::contains).collect(Collectors.toCollection(HashSet::new));
                boolean ignoreLeaderReward = false;
                if (epoch - 2 < networkConfig.getAllegraHardforkEpoch()) {
                    ignoreLeaderReward = sharedPoolRewardAddressesWithoutReward.contains(poolId);
                }
                poolRewardCalculationResult = PoolRewardsCalculation.calculatePoolRewardInEpoch(poolId, poolState, blocksInEpoch, protocolParameters, adaInCirculation, activeStakeInEpoch, stakePoolRewardsPot, poolState.getOwnerActiveStake(), poolState.getOwners(), delegatorAccountDeregistrations, ignoreLeaderReward, lateDeregisteredDelegators, registeredAccountsSinceLastEpoch, networkConfig);
            }
            totalDistributedRewards = BigNumberUtils.add(totalDistributedRewards, poolRewardCalculationResult.getDistributedPoolReward());
            unspendableEarnedRewards = unspendableEarnedRewards.add(poolRewardCalculationResult.getUnspendableEarnedRewards());
            poolRewardCalculationResults.add(poolRewardCalculationResult);
            ++i;
        }
        BigInteger undistributedRewards = BigNumberUtils.subtract(stakePoolRewardsPot, totalDistributedRewards);
        calculatedReserve = BigNumberUtils.add(calculatedReserve, undistributedRewards);
        calculatedReserve = BigNumberUtils.subtract(calculatedReserve, unspendableEarnedRewards);
        if (epoch == networkConfig.getAllegraHardforkEpoch()) {
            calculatedReserve = calculatedReserve.add(networkConfig.getBootstrapAddressAmount());
        }
        log.debug("Unspendable earned rewards: " + unspendableEarnedRewards.longValue() + " Lovelace");
        treasuryForCurrentEpoch = BigNumberUtils.add(treasuryForCurrentEpoch, unspendableEarnedRewards);
        TreasuryCalculationResult treasuryCalculationResult = TreasuryCalculationResult.builder().epoch(epoch).treasury(treasuryForCurrentEpoch).totalRewardPot(rewardPot).treasuryWithdrawals(treasuryWithdrawals).unspendableEarnedRewards(unspendableEarnedRewards).unclaimedRefunds(unclaimedRefunds).build();
        epochCalculationResult.setTotalDistributedRewards(totalDistributedRewards);
        epochCalculationResult.setTotalRewardsPot(rewardPot);
        epochCalculationResult.setReserves(calculatedReserve);
        epochCalculationResult.setTreasury(treasuryForCurrentEpoch);
        epochCalculationResult.setPoolRewardCalculationResults(poolRewardCalculationResults);
        epochCalculationResult.setTotalPoolRewardsPot(stakePoolRewardsPot);
        epochCalculationResult.setTotalAdaInCirculation(adaInCirculation);
        epochCalculationResult.setTotalUndistributedRewards(undistributedRewards);
        epochCalculationResult.setTreasuryCalculationResult(treasuryCalculationResult);
        return epochCalculationResult;
    }
}

