/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.rewards.calculation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.cardanofoundation.rewards.calculation.config.NetworkConfig;
import org.cardanofoundation.rewards.calculation.domain.Delegator;
import org.cardanofoundation.rewards.calculation.domain.PoolRewardCalculationResult;
import org.cardanofoundation.rewards.calculation.domain.PoolState;
import org.cardanofoundation.rewards.calculation.domain.ProtocolParameters;
import org.cardanofoundation.rewards.calculation.domain.Reward;
import org.cardanofoundation.rewards.calculation.util.BigNumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolRewardsCalculation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PoolRewardsCalculation.class);

    public static BigDecimal calculateApparentPoolPerformance(BigInteger activePoolStake, BigInteger totalActiveEpochStake, int blocksMintedByPool, int blocksMintedByStakePools, BigDecimal decentralizationParam) {
        BigDecimal poolStake = new BigDecimal(activePoolStake);
        BigDecimal totalEpochStake = new BigDecimal(totalActiveEpochStake);
        if (decentralizationParam.compareTo(BigDecimal.valueOf(0.8)) >= 0) {
            return BigDecimal.ONE;
        }
        if (BigNumberUtils.isZero(poolStake) || BigNumberUtils.isZero(totalEpochStake)) {
            return BigDecimal.ZERO;
        }
        BigDecimal relativeBlocksCreatedInEpoch = BigNumberUtils.divide((long)blocksMintedByPool, (long)blocksMintedByStakePools);
        BigDecimal relativeActiveStake = BigNumberUtils.divide(poolStake, totalEpochStake);
        return BigNumberUtils.divide(relativeBlocksCreatedInEpoch, relativeActiveStake);
    }

    public static BigInteger calculateOptimalPoolReward(BigInteger totalAvailableRewards, int optimalPoolCount, BigDecimal influence, BigDecimal relativeStakeOfPool, BigDecimal relativeStakeOfPoolOwner) {
        BigDecimal sizeOfASaturatedPool = BigNumberUtils.divide(BigDecimal.ONE, (double)optimalPoolCount);
        BigDecimal cappedRelativeStake = BigNumberUtils.min(relativeStakeOfPool, sizeOfASaturatedPool);
        BigDecimal cappedRelativeStakeOfPoolOwner = BigNumberUtils.min(relativeStakeOfPoolOwner, sizeOfASaturatedPool);
        BigDecimal rewardsDividedByOnePlusInfluence = BigNumberUtils.divide(totalAvailableRewards, BigNumberUtils.add(BigDecimal.ONE, influence));
        BigDecimal relativeStakeOfSaturatedPool = BigNumberUtils.divide(BigNumberUtils.subtract(sizeOfASaturatedPool, cappedRelativeStake), sizeOfASaturatedPool);
        BigDecimal saturatedPoolWeight = BigNumberUtils.divide(BigNumberUtils.subtract(cappedRelativeStake, BigNumberUtils.multiply(cappedRelativeStakeOfPoolOwner, relativeStakeOfSaturatedPool)), sizeOfASaturatedPool);
        return BigNumberUtils.floor(BigNumberUtils.multiply(rewardsDividedByOnePlusInfluence, BigNumberUtils.add(cappedRelativeStake, BigNumberUtils.multiply(cappedRelativeStakeOfPoolOwner, influence, saturatedPoolWeight))));
    }

    public static BigInteger calculatePoolReward(BigInteger optimalPoolReward, BigDecimal poolPerformance) {
        return BigNumberUtils.floor(BigNumberUtils.multiply(optimalPoolReward, poolPerformance));
    }

    public static BigInteger calculateLeaderReward(BigInteger poolReward, BigDecimal margin, BigInteger poolCost, BigDecimal relativeOwnerStake, BigDecimal relativeStakeOfPool) {
        if (BigNumberUtils.isLowerOrEquals(poolReward, poolCost)) {
            return poolReward;
        }
        return BigNumberUtils.add(poolCost, BigNumberUtils.floor(BigNumberUtils.multiply(BigNumberUtils.subtract(poolReward, poolCost), BigNumberUtils.add(margin, BigNumberUtils.multiply(BigDecimal.ONE.subtract(margin), BigNumberUtils.divide(relativeOwnerStake, relativeStakeOfPool))))));
    }

    public static BigInteger calculateMemberReward(BigInteger poolReward, BigDecimal margin, BigInteger poolCost, BigDecimal relativeMemberStake, BigDecimal relativeStakeOfPool) {
        if (BigNumberUtils.isLowerOrEquals(poolReward, poolCost)) {
            return BigInteger.ZERO;
        }
        return BigNumberUtils.floor(BigNumberUtils.divide(BigNumberUtils.multiply(poolReward.subtract(poolCost), BigNumberUtils.subtract(BigDecimal.ONE, margin), relativeMemberStake), relativeStakeOfPool));
    }

    public static PoolRewardCalculationResult calculatePoolRewardInEpoch(String poolId, PoolState poolStateCurrentEpoch, int totalBlocksInEpoch, ProtocolParameters protocolParameters, BigInteger adaInCirculation, BigInteger activeStakeInEpoch, BigInteger stakePoolRewardsPot, BigInteger totalActiveStakeOfOwners, Set<String> poolOwnerStakeAddresses, Set<String> deregisteredAccounts, boolean ignoreLeaderReward, Set<String> lateDeregisteredAccounts, Set<String> accountsRegisteredInThePast, NetworkConfig networkConfig) {
        int earnedEpoch = poolStateCurrentEpoch.getEpoch();
        PoolRewardCalculationResult poolRewardCalculationResult = PoolRewardCalculationResult.builder().epoch(earnedEpoch).poolId(poolId).poolReward(BigInteger.ZERO).distributedPoolReward(BigInteger.ZERO).unspendableEarnedRewards(BigInteger.ZERO).build();
        if (earnedEpoch >= networkConfig.getVasilHardforkEpoch()) {
            lateDeregisteredAccounts.addAll(deregisteredAccounts);
            deregisteredAccounts.clear();
        }
        BigInteger poolStake = poolStateCurrentEpoch.getActiveStake();
        BigInteger poolPledge = poolStateCurrentEpoch.getPledge();
        BigDecimal poolMargin = BigDecimal.valueOf(poolStateCurrentEpoch.getMargin());
        BigInteger poolFixedCost = poolStateCurrentEpoch.getFixedCost();
        int blocksPoolHasMinted = poolStateCurrentEpoch.getBlockCount();
        poolRewardCalculationResult.setPoolMargin(poolStateCurrentEpoch.getMargin());
        poolRewardCalculationResult.setPoolCost(poolFixedCost);
        poolRewardCalculationResult.setRewardAddress(poolStateCurrentEpoch.getRewardAddress());
        if (blocksPoolHasMinted == 0) {
            return poolRewardCalculationResult;
        }
        BigDecimal decentralizationParameter = protocolParameters.getDecentralisation();
        int optimalPoolCount = protocolParameters.getOptimalPoolCount();
        BigDecimal influenceParam = protocolParameters.getPoolOwnerInfluence();
        BigDecimal apparentPoolPerformance = PoolRewardsCalculation.calculateApparentPoolPerformance(poolStake, activeStakeInEpoch, blocksPoolHasMinted, totalBlocksInEpoch, decentralizationParameter);
        poolRewardCalculationResult.setApparentPoolPerformance(apparentPoolPerformance);
        poolRewardCalculationResult.setPoolOwnerStakeAddresses(poolOwnerStakeAddresses);
        if (BigNumberUtils.isLower(totalActiveStakeOfOwners, poolPledge)) {
            return poolRewardCalculationResult;
        }
        BigDecimal relativeStakeOfPoolOwner = BigNumberUtils.divide(poolPledge, adaInCirculation);
        BigDecimal relativePoolStake = BigNumberUtils.divide(poolStake, adaInCirculation);
        BigInteger optimalPoolReward = PoolRewardsCalculation.calculateOptimalPoolReward(stakePoolRewardsPot, optimalPoolCount, influenceParam, relativePoolStake, relativeStakeOfPoolOwner);
        poolRewardCalculationResult.setOptimalPoolReward(optimalPoolReward);
        BigInteger poolReward = PoolRewardsCalculation.calculatePoolReward(optimalPoolReward, apparentPoolPerformance);
        poolRewardCalculationResult.setPoolReward(poolReward);
        BigInteger poolOperatorReward = PoolRewardsCalculation.calculateLeaderReward(poolReward, poolMargin, poolFixedCost, BigNumberUtils.divide(totalActiveStakeOfOwners, adaInCirculation), relativePoolStake);
        BigInteger unspendableEarnedRewards = BigInteger.ZERO;
        String rewardAddress = poolRewardCalculationResult.getRewardAddress();
        if (!accountsRegisteredInThePast.contains(rewardAddress)) {
            log.info(poolRewardCalculationResult.getRewardAddress() + " has never been registered. Operator would have received " + poolOperatorReward + " but will not receive any rewards.");
            if (earnedEpoch >= networkConfig.getVasilHardforkEpoch()) {
                unspendableEarnedRewards = poolOperatorReward;
            }
            poolOperatorReward = BigInteger.ZERO;
        } else if (deregisteredAccounts.contains(rewardAddress)) {
            log.info(poolRewardCalculationResult.getRewardAddress() + " has been deregistered. Operator would have received " + poolOperatorReward + " but will not receive any rewards.");
            poolOperatorReward = BigInteger.ZERO;
        } else if (lateDeregisteredAccounts.contains(rewardAddress)) {
            log.info("[unregRU]: " + poolRewardCalculationResult.getRewardAddress() + " has been deregistered lately. Operator would have received " + poolOperatorReward + " but will not receive any rewards.");
            unspendableEarnedRewards = poolOperatorReward;
            poolOperatorReward = BigInteger.ZERO;
        }
        if (ignoreLeaderReward) {
            poolOperatorReward = BigInteger.ZERO;
            log.debug("[reward address of multiple pools] Pool " + poolId + " has been ignored. Operator would have received " + poolOperatorReward + " but will not receive any rewards.");
        }
        BigInteger poolMemberRewards = BigInteger.ZERO;
        HashSet<Reward> memberRewards = new HashSet<Reward>();
        for (Delegator delegator : poolStateCurrentEpoch.getDelegators()) {
            String stakeAddress = delegator.getStakeAddress();
            if (stakeAddress.equals(poolStateCurrentEpoch.getRewardAddress()) && earnedEpoch < networkConfig.getAllegraHardforkEpoch() || poolOwnerStakeAddresses.contains(stakeAddress)) continue;
            BigInteger memberReward = PoolRewardsCalculation.calculateMemberReward(poolReward, poolMargin, poolFixedCost, BigNumberUtils.divide(delegator.getActiveStake(), adaInCirculation), relativePoolStake);
            if (deregisteredAccounts.contains(stakeAddress)) {
                log.debug("Delegator " + stakeAddress + " has been deregistered. Delegator would have received " + memberReward + " but will not receive any rewards.");
                memberReward = BigInteger.ZERO;
            } else if (lateDeregisteredAccounts.contains(stakeAddress)) {
                log.debug("[unregRU]: " + stakeAddress + " has been deregistered lately. Delegator would have received " + memberReward + " but will not receive any rewards.");
                unspendableEarnedRewards = unspendableEarnedRewards.add(memberReward);
                memberReward = BigInteger.ZERO;
            }
            memberRewards.add(Reward.builder().amount(memberReward).stakeAddress(stakeAddress).build());
            poolMemberRewards = poolMemberRewards.add(memberReward);
        }
        poolRewardCalculationResult.setDistributedPoolReward(poolOperatorReward.add(poolMemberRewards));
        poolRewardCalculationResult.setOperatorReward(poolOperatorReward);
        poolRewardCalculationResult.setMemberRewards(memberRewards);
        poolRewardCalculationResult.setUnspendableEarnedRewards(unspendableEarnedRewards);
        return poolRewardCalculationResult;
    }
}

