/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.rewards.calculation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.rewards.calculation.config.NetworkConfig;
import org.cardanofoundation.rewards.calculation.domain.AdaPots;
import org.cardanofoundation.rewards.calculation.domain.Epoch;
import org.cardanofoundation.rewards.calculation.domain.MirCertificate;
import org.cardanofoundation.rewards.calculation.domain.ProtocolParameters;
import org.cardanofoundation.rewards.calculation.domain.RetiredPool;
import org.cardanofoundation.rewards.calculation.domain.TreasuryCalculationResult;
import org.cardanofoundation.rewards.calculation.enums.MirPot;
import org.cardanofoundation.rewards.calculation.util.BigNumberUtils;

public class TreasuryCalculation {
    public static TreasuryCalculationResult calculateTreasuryInEpoch(int epoch, ProtocolParameters protocolParameters, AdaPots adaPotsForPreviousEpoch, Epoch epochInfo, Set<RetiredPool> retiredPools, List<MirCertificate> mirCertificates, HashSet<String> deregisteredAccounts, HashSet<String> registeredAccountsUntilNow, BigInteger unspendableEarnedRewards, NetworkConfig networkConfig) {
        if (epoch <= networkConfig.getShelleyStartEpoch()) {
            return TreasuryCalculationResult.builder().treasury(BigInteger.ZERO).epoch(epoch).totalRewardPot(BigInteger.ZERO).treasuryWithdrawals(BigInteger.ZERO).unspendableEarnedRewards(BigInteger.ZERO).unclaimedRefunds(BigInteger.ZERO).build();
        }
        BigInteger totalFeesForCurrentEpoch = BigInteger.ZERO;
        int totalBlocksInEpoch = 0;
        BigDecimal treasuryGrowthRate = protocolParameters.getTreasuryGrowRate();
        BigDecimal monetaryExpandRate = protocolParameters.getMonetaryExpandRate();
        BigDecimal decentralizationParameter = protocolParameters.getDecentralisation();
        if (epochInfo != null) {
            totalFeesForCurrentEpoch = epochInfo.getFees();
            totalBlocksInEpoch = epochInfo.getBlockCount();
            if (BigNumberUtils.isLower(decentralizationParameter, BigDecimal.valueOf(0.8)) && BigNumberUtils.isHigher(decentralizationParameter, BigDecimal.ZERO)) {
                totalBlocksInEpoch = epochInfo.getNonOBFTBlockCount();
            }
        }
        BigInteger reserveInPreviousEpoch = adaPotsForPreviousEpoch.getReserves();
        BigInteger treasuryInPreviousEpoch = adaPotsForPreviousEpoch.getTreasury();
        BigInteger totalRewardPot = TreasuryCalculation.calculateTotalRewardPotWithEta(monetaryExpandRate, totalBlocksInEpoch, decentralizationParameter, reserveInPreviousEpoch, totalFeesForCurrentEpoch, networkConfig);
        BigInteger treasuryCut = BigNumberUtils.multiplyAndFloor(totalRewardPot, treasuryGrowthRate);
        BigInteger treasuryForCurrentEpoch = treasuryInPreviousEpoch.add(treasuryCut);
        Set rewardAddressesOfRetiredPools = retiredPools.stream().map(RetiredPool::getRewardAddress).collect(Collectors.toSet());
        BigInteger unclaimedRefunds = BigInteger.ZERO;
        if (rewardAddressesOfRetiredPools.size() > 0) {
            HashSet deregisteredRewardAccounts = deregisteredAccounts.stream().filter(rewardAddressesOfRetiredPools::contains).collect(Collectors.toCollection(HashSet::new));
            List<String> ownerAccountsRegisteredInThePast = registeredAccountsUntilNow.stream().filter(rewardAddressesOfRetiredPools::contains).toList();
            unclaimedRefunds = TreasuryCalculation.calculateUnclaimedRefundsForRetiredPools(retiredPools, deregisteredRewardAccounts, ownerAccountsRegisteredInThePast, networkConfig);
            treasuryForCurrentEpoch = treasuryForCurrentEpoch.add(unclaimedRefunds);
        }
        BigInteger treasuryWithdrawals = BigInteger.ZERO;
        for (MirCertificate mirCertificate : mirCertificates) {
            if (mirCertificate.getPot() != MirPot.TREASURY) continue;
            treasuryWithdrawals = treasuryWithdrawals.add(mirCertificate.getTotalRewards());
        }
        treasuryForCurrentEpoch = treasuryForCurrentEpoch.subtract(treasuryWithdrawals);
        treasuryForCurrentEpoch = treasuryForCurrentEpoch.add(unspendableEarnedRewards);
        return TreasuryCalculationResult.builder().treasury(treasuryForCurrentEpoch).epoch(epoch).totalRewardPot(totalRewardPot).treasuryWithdrawals(treasuryWithdrawals).unspendableEarnedRewards(unspendableEarnedRewards).unclaimedRefunds(unclaimedRefunds).build();
    }

    public static BigInteger calculateTotalRewardPotWithEta(BigDecimal monetaryExpandRate, int totalBlocksInEpochByPools, BigDecimal decentralizationParameter, BigInteger reserve, BigInteger fee, NetworkConfig networkConfig) {
        BigDecimal eta = TreasuryCalculation.calculateEta(totalBlocksInEpochByPools, decentralizationParameter, networkConfig);
        return BigNumberUtils.multiplyAndFloor(reserve, monetaryExpandRate, eta).add(fee);
    }

    private static BigDecimal calculateEta(int totalBlocksInEpochByPools, BigDecimal decentralizationParameter, NetworkConfig networkConfig) {
        BigDecimal decentralisationThreshold = new BigDecimal("0.8");
        if (decentralizationParameter.compareTo(decentralisationThreshold) >= 0) {
            return BigDecimal.ONE;
        }
        BigDecimal activeSlotsCoeff = BigDecimal.valueOf(networkConfig.getActiveSlotCoefficient());
        BigDecimal expectedBlocksInNonOBFTSlots = new BigDecimal(networkConfig.getExpectedSlotsPerEpoch()).multiply(activeSlotsCoeff).multiply(BigDecimal.ONE.subtract(decentralizationParameter));
        MathContext mathContext = new MathContext(32);
        return new BigDecimal(totalBlocksInEpochByPools).divide(expectedBlocksInNonOBFTSlots, mathContext).min(BigDecimal.ONE);
    }

    public static BigInteger calculateUnclaimedRefundsForRetiredPools(Set<RetiredPool> retiredPools, HashSet<String> deregisteredRewardAccounts, List<String> ownerAccountsRegisteredInThePast, NetworkConfig networkConfig) {
        BigInteger unclaimedRefunds = BigInteger.ZERO;
        if (retiredPools.size() > 0) {
            for (RetiredPool retiredPool : retiredPools) {
                if (!deregisteredRewardAccounts.contains(retiredPool.getRewardAddress()) && ownerAccountsRegisteredInThePast.contains(retiredPool.getRewardAddress())) continue;
                BigInteger depositAmount = BigInteger.valueOf(500000000L);
                if (retiredPool.getDepositAmount() != null) {
                    depositAmount = retiredPool.getDepositAmount();
                }
                unclaimedRefunds = unclaimedRefunds.add(depositAmount);
            }
        }
        return unclaimedRefunds;
    }
}

