/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.rewards.calculation.config;

import java.math.BigDecimal;
import java.math.BigInteger;
import lombok.Generated;

public class NetworkConfig {
    private int networkMagic;
    private BigInteger totalLovelace;
    private BigInteger poolDepositInLovelace;
    private long expectedSlotsPerEpoch;
    private BigInteger shelleyInitialReserves;
    private BigInteger shelleyInitialTreasury;
    private BigInteger shelleyInitialUtxo;
    private int genesisConfigSecurityParameter;
    private int shelleyStartEpoch;
    private int allegraHardforkEpoch;
    private int vasilHardforkEpoch;
    private BigInteger bootstrapAddressAmount;
    private double activeSlotCoefficient;
    private long randomnessStabilisationWindow;
    private BigDecimal shelleyStartDecentralisation;
    private BigDecimal shelleyStartTreasuryGrowRate;
    private BigDecimal shelleyStartMonetaryExpandRate;
    private int shelleyStartOptimalPoolCount;
    private BigDecimal shelleyStartPoolOwnerInfluence;
    public static final int MAINNET_NETWORK_MAGIC = 764824073;
    public static final int PREPROD_NETWORK_MAGIC = 1;
    public static final int PREVIEW_NETWORK_MAGIC = 2;
    public static final int SANCHONET_NETWORK_MAGIC = 4;

    public static NetworkConfig getMainnetConfig() {
        return NetworkConfig.builder().networkMagic(764824073).totalLovelace(new BigInteger("45000000000000000")).poolDepositInLovelace(BigInteger.valueOf(500000000L)).expectedSlotsPerEpoch(432000L).shelleyInitialReserves(new BigInteger("13888022852926644")).shelleyInitialTreasury(new BigInteger("0")).shelleyInitialUtxo(new BigInteger("31111977147073356")).genesisConfigSecurityParameter(2160).shelleyStartEpoch(208).allegraHardforkEpoch(236).vasilHardforkEpoch(365).bootstrapAddressAmount(new BigInteger("318200635000000")).activeSlotCoefficient(0.05).randomnessStabilisationWindow(172800L).shelleyStartDecentralisation(BigDecimal.valueOf(1.0)).shelleyStartTreasuryGrowRate(BigDecimal.valueOf(0.2)).shelleyStartMonetaryExpandRate(BigDecimal.valueOf(0.003)).shelleyStartOptimalPoolCount(150).shelleyStartPoolOwnerInfluence(BigDecimal.valueOf(0.03)).build();
    }

    public static NetworkConfig getPreprodConfig() {
        return NetworkConfig.builder().networkMagic(1).totalLovelace(new BigInteger("45000000000000000")).poolDepositInLovelace(BigInteger.valueOf(500000000L)).expectedSlotsPerEpoch(432000L).shelleyInitialReserves(new BigInteger("15000000000000000")).shelleyInitialTreasury(new BigInteger("0")).shelleyInitialUtxo(new BigInteger("30000000000000000")).genesisConfigSecurityParameter(2160).shelleyStartEpoch(4).allegraHardforkEpoch(5).vasilHardforkEpoch(12).bootstrapAddressAmount(new BigInteger("0")).activeSlotCoefficient(0.05).randomnessStabilisationWindow(172800L).shelleyStartDecentralisation(BigDecimal.valueOf(1.0)).shelleyStartTreasuryGrowRate(BigDecimal.valueOf(0.2)).shelleyStartMonetaryExpandRate(BigDecimal.valueOf(0.003)).shelleyStartOptimalPoolCount(150).shelleyStartPoolOwnerInfluence(BigDecimal.valueOf(0.03)).build();
    }

    public static NetworkConfig getPreviewConfig() {
        return NetworkConfig.builder().networkMagic(2).totalLovelace(new BigInteger("45000000000000000")).poolDepositInLovelace(BigInteger.valueOf(500000000L)).expectedSlotsPerEpoch(86400L).shelleyInitialReserves(new BigInteger("14991000000000000")).shelleyInitialTreasury(new BigInteger("9000000000000")).shelleyInitialUtxo(new BigInteger("30009000000000000")).genesisConfigSecurityParameter(432).shelleyStartEpoch(1).allegraHardforkEpoch(1).vasilHardforkEpoch(3).bootstrapAddressAmount(new BigInteger("0")).activeSlotCoefficient(0.05).randomnessStabilisationWindow(34560L).shelleyStartDecentralisation(BigDecimal.valueOf(1.0)).shelleyStartTreasuryGrowRate(BigDecimal.valueOf(0.2)).shelleyStartMonetaryExpandRate(BigDecimal.valueOf(0.003)).shelleyStartOptimalPoolCount(150).shelleyStartPoolOwnerInfluence(BigDecimal.valueOf(0.03)).build();
    }

    public static NetworkConfig getSanchonetConfig() {
        return NetworkConfig.builder().networkMagic(2).totalLovelace(new BigInteger("45000000000000000")).poolDepositInLovelace(BigInteger.valueOf(500000000L)).expectedSlotsPerEpoch(86400L).shelleyInitialReserves(new BigInteger("14991000000000000")).shelleyInitialTreasury(new BigInteger("9000000000000")).shelleyInitialUtxo(new BigInteger("30009000000000000")).genesisConfigSecurityParameter(432).shelleyStartEpoch(1).allegraHardforkEpoch(1).vasilHardforkEpoch(3).bootstrapAddressAmount(new BigInteger("0")).activeSlotCoefficient(0.05).randomnessStabilisationWindow(34560L).shelleyStartDecentralisation(BigDecimal.valueOf(1.0)).shelleyStartTreasuryGrowRate(BigDecimal.valueOf(0.2)).shelleyStartMonetaryExpandRate(BigDecimal.valueOf(0.003)).shelleyStartOptimalPoolCount(150).shelleyStartPoolOwnerInfluence(BigDecimal.valueOf(0.03)).build();
    }

    public static NetworkConfig getNetworkConfigByNetworkMagic(int networkMagic) {
        return switch (networkMagic) {
            case 764824073 -> NetworkConfig.getMainnetConfig();
            case 1 -> NetworkConfig.getPreprodConfig();
            case 2 -> NetworkConfig.getPreviewConfig();
            case 4 -> NetworkConfig.getSanchonetConfig();
            default -> throw new IllegalArgumentException("Invalid network magic: " + networkMagic);
        };
    }

    @Generated
    public static NetworkConfigBuilder builder() {
        return new NetworkConfigBuilder();
    }

    @Generated
    public int getNetworkMagic() {
        return this.networkMagic;
    }

    @Generated
    public BigInteger getTotalLovelace() {
        return this.totalLovelace;
    }

    @Generated
    public BigInteger getPoolDepositInLovelace() {
        return this.poolDepositInLovelace;
    }

    @Generated
    public long getExpectedSlotsPerEpoch() {
        return this.expectedSlotsPerEpoch;
    }

    @Generated
    public BigInteger getShelleyInitialReserves() {
        return this.shelleyInitialReserves;
    }

    @Generated
    public BigInteger getShelleyInitialTreasury() {
        return this.shelleyInitialTreasury;
    }

    @Generated
    public BigInteger getShelleyInitialUtxo() {
        return this.shelleyInitialUtxo;
    }

    @Generated
    public int getGenesisConfigSecurityParameter() {
        return this.genesisConfigSecurityParameter;
    }

    @Generated
    public int getShelleyStartEpoch() {
        return this.shelleyStartEpoch;
    }

    @Generated
    public int getAllegraHardforkEpoch() {
        return this.allegraHardforkEpoch;
    }

    @Generated
    public int getVasilHardforkEpoch() {
        return this.vasilHardforkEpoch;
    }

    @Generated
    public BigInteger getBootstrapAddressAmount() {
        return this.bootstrapAddressAmount;
    }

    @Generated
    public double getActiveSlotCoefficient() {
        return this.activeSlotCoefficient;
    }

    @Generated
    public long getRandomnessStabilisationWindow() {
        return this.randomnessStabilisationWindow;
    }

    @Generated
    public BigDecimal getShelleyStartDecentralisation() {
        return this.shelleyStartDecentralisation;
    }

    @Generated
    public BigDecimal getShelleyStartTreasuryGrowRate() {
        return this.shelleyStartTreasuryGrowRate;
    }

    @Generated
    public BigDecimal getShelleyStartMonetaryExpandRate() {
        return this.shelleyStartMonetaryExpandRate;
    }

    @Generated
    public int getShelleyStartOptimalPoolCount() {
        return this.shelleyStartOptimalPoolCount;
    }

    @Generated
    public BigDecimal getShelleyStartPoolOwnerInfluence() {
        return this.shelleyStartPoolOwnerInfluence;
    }

    @Generated
    public void setNetworkMagic(int networkMagic) {
        this.networkMagic = networkMagic;
    }

    @Generated
    public void setTotalLovelace(BigInteger totalLovelace) {
        this.totalLovelace = totalLovelace;
    }

    @Generated
    public void setPoolDepositInLovelace(BigInteger poolDepositInLovelace) {
        this.poolDepositInLovelace = poolDepositInLovelace;
    }

    @Generated
    public void setExpectedSlotsPerEpoch(long expectedSlotsPerEpoch) {
        this.expectedSlotsPerEpoch = expectedSlotsPerEpoch;
    }

    @Generated
    public void setShelleyInitialReserves(BigInteger shelleyInitialReserves) {
        this.shelleyInitialReserves = shelleyInitialReserves;
    }

    @Generated
    public void setShelleyInitialTreasury(BigInteger shelleyInitialTreasury) {
        this.shelleyInitialTreasury = shelleyInitialTreasury;
    }

    @Generated
    public void setShelleyInitialUtxo(BigInteger shelleyInitialUtxo) {
        this.shelleyInitialUtxo = shelleyInitialUtxo;
    }

    @Generated
    public void setGenesisConfigSecurityParameter(int genesisConfigSecurityParameter) {
        this.genesisConfigSecurityParameter = genesisConfigSecurityParameter;
    }

    @Generated
    public void setShelleyStartEpoch(int shelleyStartEpoch) {
        this.shelleyStartEpoch = shelleyStartEpoch;
    }

    @Generated
    public void setAllegraHardforkEpoch(int allegraHardforkEpoch) {
        this.allegraHardforkEpoch = allegraHardforkEpoch;
    }

    @Generated
    public void setVasilHardforkEpoch(int vasilHardforkEpoch) {
        this.vasilHardforkEpoch = vasilHardforkEpoch;
    }

    @Generated
    public void setBootstrapAddressAmount(BigInteger bootstrapAddressAmount) {
        this.bootstrapAddressAmount = bootstrapAddressAmount;
    }

    @Generated
    public void setActiveSlotCoefficient(double activeSlotCoefficient) {
        this.activeSlotCoefficient = activeSlotCoefficient;
    }

    @Generated
    public void setRandomnessStabilisationWindow(long randomnessStabilisationWindow) {
        this.randomnessStabilisationWindow = randomnessStabilisationWindow;
    }

    @Generated
    public void setShelleyStartDecentralisation(BigDecimal shelleyStartDecentralisation) {
        this.shelleyStartDecentralisation = shelleyStartDecentralisation;
    }

    @Generated
    public void setShelleyStartTreasuryGrowRate(BigDecimal shelleyStartTreasuryGrowRate) {
        this.shelleyStartTreasuryGrowRate = shelleyStartTreasuryGrowRate;
    }

    @Generated
    public void setShelleyStartMonetaryExpandRate(BigDecimal shelleyStartMonetaryExpandRate) {
        this.shelleyStartMonetaryExpandRate = shelleyStartMonetaryExpandRate;
    }

    @Generated
    public void setShelleyStartOptimalPoolCount(int shelleyStartOptimalPoolCount) {
        this.shelleyStartOptimalPoolCount = shelleyStartOptimalPoolCount;
    }

    @Generated
    public void setShelleyStartPoolOwnerInfluence(BigDecimal shelleyStartPoolOwnerInfluence) {
        this.shelleyStartPoolOwnerInfluence = shelleyStartPoolOwnerInfluence;
    }

    @Generated
    public NetworkConfig(int networkMagic, BigInteger totalLovelace, BigInteger poolDepositInLovelace, long expectedSlotsPerEpoch, BigInteger shelleyInitialReserves, BigInteger shelleyInitialTreasury, BigInteger shelleyInitialUtxo, int genesisConfigSecurityParameter, int shelleyStartEpoch, int allegraHardforkEpoch, int vasilHardforkEpoch, BigInteger bootstrapAddressAmount, double activeSlotCoefficient, long randomnessStabilisationWindow, BigDecimal shelleyStartDecentralisation, BigDecimal shelleyStartTreasuryGrowRate, BigDecimal shelleyStartMonetaryExpandRate, int shelleyStartOptimalPoolCount, BigDecimal shelleyStartPoolOwnerInfluence) {
        this.networkMagic = networkMagic;
        this.totalLovelace = totalLovelace;
        this.poolDepositInLovelace = poolDepositInLovelace;
        this.expectedSlotsPerEpoch = expectedSlotsPerEpoch;
        this.shelleyInitialReserves = shelleyInitialReserves;
        this.shelleyInitialTreasury = shelleyInitialTreasury;
        this.shelleyInitialUtxo = shelleyInitialUtxo;
        this.genesisConfigSecurityParameter = genesisConfigSecurityParameter;
        this.shelleyStartEpoch = shelleyStartEpoch;
        this.allegraHardforkEpoch = allegraHardforkEpoch;
        this.vasilHardforkEpoch = vasilHardforkEpoch;
        this.bootstrapAddressAmount = bootstrapAddressAmount;
        this.activeSlotCoefficient = activeSlotCoefficient;
        this.randomnessStabilisationWindow = randomnessStabilisationWindow;
        this.shelleyStartDecentralisation = shelleyStartDecentralisation;
        this.shelleyStartTreasuryGrowRate = shelleyStartTreasuryGrowRate;
        this.shelleyStartMonetaryExpandRate = shelleyStartMonetaryExpandRate;
        this.shelleyStartOptimalPoolCount = shelleyStartOptimalPoolCount;
        this.shelleyStartPoolOwnerInfluence = shelleyStartPoolOwnerInfluence;
    }

    @Generated
    public NetworkConfig() {
    }

    @Generated
    public static class NetworkConfigBuilder {
        @Generated
        private int networkMagic;
        @Generated
        private BigInteger totalLovelace;
        @Generated
        private BigInteger poolDepositInLovelace;
        @Generated
        private long expectedSlotsPerEpoch;
        @Generated
        private BigInteger shelleyInitialReserves;
        @Generated
        private BigInteger shelleyInitialTreasury;
        @Generated
        private BigInteger shelleyInitialUtxo;
        @Generated
        private int genesisConfigSecurityParameter;
        @Generated
        private int shelleyStartEpoch;
        @Generated
        private int allegraHardforkEpoch;
        @Generated
        private int vasilHardforkEpoch;
        @Generated
        private BigInteger bootstrapAddressAmount;
        @Generated
        private double activeSlotCoefficient;
        @Generated
        private long randomnessStabilisationWindow;
        @Generated
        private BigDecimal shelleyStartDecentralisation;
        @Generated
        private BigDecimal shelleyStartTreasuryGrowRate;
        @Generated
        private BigDecimal shelleyStartMonetaryExpandRate;
        @Generated
        private int shelleyStartOptimalPoolCount;
        @Generated
        private BigDecimal shelleyStartPoolOwnerInfluence;

        @Generated
        NetworkConfigBuilder() {
        }

        @Generated
        public NetworkConfigBuilder networkMagic(int networkMagic) {
            this.networkMagic = networkMagic;
            return this;
        }

        @Generated
        public NetworkConfigBuilder totalLovelace(BigInteger totalLovelace) {
            this.totalLovelace = totalLovelace;
            return this;
        }

        @Generated
        public NetworkConfigBuilder poolDepositInLovelace(BigInteger poolDepositInLovelace) {
            this.poolDepositInLovelace = poolDepositInLovelace;
            return this;
        }

        @Generated
        public NetworkConfigBuilder expectedSlotsPerEpoch(long expectedSlotsPerEpoch) {
            this.expectedSlotsPerEpoch = expectedSlotsPerEpoch;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyInitialReserves(BigInteger shelleyInitialReserves) {
            this.shelleyInitialReserves = shelleyInitialReserves;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyInitialTreasury(BigInteger shelleyInitialTreasury) {
            this.shelleyInitialTreasury = shelleyInitialTreasury;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyInitialUtxo(BigInteger shelleyInitialUtxo) {
            this.shelleyInitialUtxo = shelleyInitialUtxo;
            return this;
        }

        @Generated
        public NetworkConfigBuilder genesisConfigSecurityParameter(int genesisConfigSecurityParameter) {
            this.genesisConfigSecurityParameter = genesisConfigSecurityParameter;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyStartEpoch(int shelleyStartEpoch) {
            this.shelleyStartEpoch = shelleyStartEpoch;
            return this;
        }

        @Generated
        public NetworkConfigBuilder allegraHardforkEpoch(int allegraHardforkEpoch) {
            this.allegraHardforkEpoch = allegraHardforkEpoch;
            return this;
        }

        @Generated
        public NetworkConfigBuilder vasilHardforkEpoch(int vasilHardforkEpoch) {
            this.vasilHardforkEpoch = vasilHardforkEpoch;
            return this;
        }

        @Generated
        public NetworkConfigBuilder bootstrapAddressAmount(BigInteger bootstrapAddressAmount) {
            this.bootstrapAddressAmount = bootstrapAddressAmount;
            return this;
        }

        @Generated
        public NetworkConfigBuilder activeSlotCoefficient(double activeSlotCoefficient) {
            this.activeSlotCoefficient = activeSlotCoefficient;
            return this;
        }

        @Generated
        public NetworkConfigBuilder randomnessStabilisationWindow(long randomnessStabilisationWindow) {
            this.randomnessStabilisationWindow = randomnessStabilisationWindow;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyStartDecentralisation(BigDecimal shelleyStartDecentralisation) {
            this.shelleyStartDecentralisation = shelleyStartDecentralisation;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyStartTreasuryGrowRate(BigDecimal shelleyStartTreasuryGrowRate) {
            this.shelleyStartTreasuryGrowRate = shelleyStartTreasuryGrowRate;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyStartMonetaryExpandRate(BigDecimal shelleyStartMonetaryExpandRate) {
            this.shelleyStartMonetaryExpandRate = shelleyStartMonetaryExpandRate;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyStartOptimalPoolCount(int shelleyStartOptimalPoolCount) {
            this.shelleyStartOptimalPoolCount = shelleyStartOptimalPoolCount;
            return this;
        }

        @Generated
        public NetworkConfigBuilder shelleyStartPoolOwnerInfluence(BigDecimal shelleyStartPoolOwnerInfluence) {
            this.shelleyStartPoolOwnerInfluence = shelleyStartPoolOwnerInfluence;
            return this;
        }

        @Generated
        public NetworkConfig build() {
            return new NetworkConfig(this.networkMagic, this.totalLovelace, this.poolDepositInLovelace, this.expectedSlotsPerEpoch, this.shelleyInitialReserves, this.shelleyInitialTreasury, this.shelleyInitialUtxo, this.genesisConfigSecurityParameter, this.shelleyStartEpoch, this.allegraHardforkEpoch, this.vasilHardforkEpoch, this.bootstrapAddressAmount, this.activeSlotCoefficient, this.randomnessStabilisationWindow, this.shelleyStartDecentralisation, this.shelleyStartTreasuryGrowRate, this.shelleyStartMonetaryExpandRate, this.shelleyStartOptimalPoolCount, this.shelleyStartPoolOwnerInfluence);
        }

        @Generated
        public String toString() {
            return "NetworkConfig.NetworkConfigBuilder(networkMagic=" + this.networkMagic + ", totalLovelace=" + this.totalLovelace + ", poolDepositInLovelace=" + this.poolDepositInLovelace + ", expectedSlotsPerEpoch=" + this.expectedSlotsPerEpoch + ", shelleyInitialReserves=" + this.shelleyInitialReserves + ", shelleyInitialTreasury=" + this.shelleyInitialTreasury + ", shelleyInitialUtxo=" + this.shelleyInitialUtxo + ", genesisConfigSecurityParameter=" + this.genesisConfigSecurityParameter + ", shelleyStartEpoch=" + this.shelleyStartEpoch + ", allegraHardforkEpoch=" + this.allegraHardforkEpoch + ", vasilHardforkEpoch=" + this.vasilHardforkEpoch + ", bootstrapAddressAmount=" + this.bootstrapAddressAmount + ", activeSlotCoefficient=" + this.activeSlotCoefficient + ", randomnessStabilisationWindow=" + this.randomnessStabilisationWindow + ", shelleyStartDecentralisation=" + this.shelleyStartDecentralisation + ", shelleyStartTreasuryGrowRate=" + this.shelleyStartTreasuryGrowRate + ", shelleyStartMonetaryExpandRate=" + this.shelleyStartMonetaryExpandRate + ", shelleyStartOptimalPoolCount=" + this.shelleyStartOptimalPoolCount + ", shelleyStartPoolOwnerInfluence=" + this.shelleyStartPoolOwnerInfluence + ")";
        }
    }
}

