/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.time.Duration;
import java.util.Properties;
import org.carlspring.cloud.storage.s3fs.S3AwsRegionProviderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.Protocol;

public abstract class S3Factory {
    public static final String REGION = "s3fs.region";
    public static final String ACCESS_KEY = "s3fs.access.key";
    public static final String SECRET_KEY = "s3fs.secret.key";
    public static final String CACHE_ATTRIBUTES_TTL = "s3fs.cache.attributes.ttl";
    public static final int CACHE_ATTRIBUTES_TTL_DEFAULT = 60000;
    public static final String CACHE_ATTRIBUTES_SIZE = "s3fs.cache.attributes.size";
    public static final int CACHE_ATTRIBUTES_SIZE_DEFAULT = 30000;
    public static final String REQUEST_METRIC_COLLECTOR_CLASS = "s3fs.request.metric.collector.class";
    public static final String CONNECTION_TIMEOUT = "s3fs.connection.timeout";
    public static final String MAX_CONNECTIONS = "s3fs.max.connections";
    public static final String MAX_ERROR_RETRY = "s3fs.max.retry.error";
    public static final String PROTOCOL = "s3fs.protocol";
    public static final String PROXY_DOMAIN = "s3fs.proxy.domain";
    public static final String PROXY_HOST = "s3fs.proxy.host";
    public static final String PROXY_PASSWORD = "s3fs.proxy.password";
    public static final String PROXY_PORT = "s3fs.proxy.port";
    public static final String PROXY_USERNAME = "s3fs.proxy.username";
    public static final String PROXY_WORKSTATION = "s3fs.proxy.workstation";
    public static final String PROXY_PROTOCOL = "s3fs.proxy.protocol";
    @Deprecated
    public static final String SOCKET_SEND_BUFFER_SIZE_HINT = "s3fs.socket.send.buffer.size.hint";
    @Deprecated
    public static final String SOCKET_RECEIVE_BUFFER_SIZE_HINT = "s3fs.socket.receive.buffer.size.hint";
    public static final String SOCKET_TIMEOUT = "s3fs.socket.timeout";
    public static final String USER_AGENT = "s3fs.user.agent";
    public static final String SIGNER_OVERRIDE = "s3fs.signer.override";
    public static final String PATH_STYLE_ACCESS = "s3fs.path.style.access";
    public static final String REQUEST_HEADER_CACHE_CONTROL = "s3fs.request.header.cache-control";
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Factory.class);
    private static final String DEFAULT_PROTOCOL = Protocol.HTTPS.toString();
    private static final Region DEFAULT_REGION = Region.US_EAST_1;
    private static final int RADIX = 10;

    public S3Client getS3Client(URI uri, Properties props) {
        S3ClientBuilder builder = this.getS3ClientBuilder();
        if (uri.getHost() != null) {
            URI endpoint = this.getEndpointUri(uri.getHost(), uri.getPort(), props);
            builder.endpointOverride(endpoint);
        }
        ((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)builder.region(this.getRegion(props))).credentialsProvider(this.getCredentialsProvider(props))).httpClient(this.getHttpClient(props))).overrideConfiguration(this.getOverrideConfiguration(props))).serviceConfiguration(this.getServiceConfiguration(props));
        return this.createS3Client(builder);
    }

    private URI getEndpointUri(String host, int port, Properties props) {
        String scheme = this.getProtocol(props);
        String endpointStr = port != -1 ? String.format("%s://%s:%d", scheme, host, port) : String.format("%s://%s", scheme, host);
        return URI.create(endpointStr);
    }

    protected S3ClientBuilder getS3ClientBuilder() {
        return S3Client.builder();
    }

    private String getProtocol(Properties props) {
        if (props.getProperty(PROTOCOL) != null) {
            return Protocol.fromValue((String)props.getProperty(PROTOCOL)).toString();
        }
        return DEFAULT_PROTOCOL;
    }

    private Region getRegion(Properties props) {
        if (props.getProperty(REGION) != null) {
            return Region.of((String)props.getProperty(REGION));
        }
        try {
            return this.getAwsRegionProvider().getRegion();
        }
        catch (SdkClientException e) {
            LOGGER.warn("Unable to load region from any of the providers in the chain", (Throwable)e);
            return DEFAULT_REGION;
        }
    }

    private AwsRegionProvider getAwsRegionProvider() {
        return S3AwsRegionProviderChain.builder().build();
    }

    protected SdkHttpClient getHttpClient(Properties props) {
        ApacheHttpClient.Builder builder = this.getApacheHttpClientBuilder(props);
        return builder.build();
    }

    private ApacheHttpClient.Builder getApacheHttpClientBuilder(Properties props) {
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        if (props.getProperty(CONNECTION_TIMEOUT) != null) {
            try {
                Duration duration = Duration.ofMillis(Long.parseLong(props.getProperty(CONNECTION_TIMEOUT), 10));
                builder.connectionTimeout(duration);
            }
            catch (NumberFormatException e) {
                this.printWarningMessage(props, CONNECTION_TIMEOUT);
            }
        }
        if (props.getProperty(MAX_CONNECTIONS) != null) {
            try {
                int maxConnections = Integer.parseInt(props.getProperty(MAX_CONNECTIONS), 10);
                builder.maxConnections(Integer.valueOf(maxConnections));
            }
            catch (NumberFormatException e) {
                this.printWarningMessage(props, MAX_CONNECTIONS);
            }
        }
        if (props.getProperty(SOCKET_TIMEOUT) != null) {
            try {
                Duration duration = Duration.ofMillis(Long.parseLong(props.getProperty(SOCKET_TIMEOUT), 10));
                builder.socketTimeout(duration);
            }
            catch (NumberFormatException e) {
                this.printWarningMessage(props, SOCKET_TIMEOUT);
            }
        }
        return builder.proxyConfiguration(this.getProxyConfiguration(props));
    }

    protected abstract S3Client createS3Client(S3ClientBuilder var1);

    protected AwsCredentialsProvider getCredentialsProvider(Properties props) {
        DefaultCredentialsProvider credentialsProvider;
        if (props.getProperty(ACCESS_KEY) == null && props.getProperty(SECRET_KEY) == null) {
            credentialsProvider = DefaultCredentialsProvider.create();
        } else {
            AwsCredentials awsCredentials = this.getAwsCredentials(props);
            credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        return credentialsProvider;
    }

    protected AwsCredentials getAwsCredentials(Properties props) {
        return AwsBasicCredentials.create((String)props.getProperty(ACCESS_KEY), (String)props.getProperty(SECRET_KEY));
    }

    protected S3Configuration getServiceConfiguration(Properties props) {
        S3Configuration.Builder builder = S3Configuration.builder();
        if (props.getProperty(PATH_STYLE_ACCESS) != null && Boolean.parseBoolean(props.getProperty(PATH_STYLE_ACCESS))) {
            builder.pathStyleAccessEnabled(Boolean.valueOf(true));
        }
        return (S3Configuration)builder.build();
    }

    protected ClientOverrideConfiguration getOverrideConfiguration(Properties props) {
        ClientOverrideConfiguration.Builder builder = ClientOverrideConfiguration.builder();
        if (props.getProperty(MAX_ERROR_RETRY) != null) {
            try {
                Integer numRetries = Integer.parseInt(props.getProperty(MAX_ERROR_RETRY), 10);
                RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(numRetries).build();
                builder.retryPolicy(retryPolicy);
            }
            catch (NumberFormatException e) {
                this.printWarningMessage(props, MAX_ERROR_RETRY);
            }
        }
        if (props.getProperty(USER_AGENT) != null) {
            builder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)props.getProperty(USER_AGENT));
        }
        if (props.getProperty(SIGNER_OVERRIDE) != null) {
            try {
                Class<?> clazz = Class.forName(props.getProperty(SIGNER_OVERRIDE));
                Signer signer = (Signer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                builder.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)signer);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.printWarningMessage(props, SIGNER_OVERRIDE);
            }
        }
        return (ClientOverrideConfiguration)builder.build();
    }

    protected ProxyConfiguration getProxyConfiguration(Properties props) {
        ProxyConfiguration.Builder builder = ProxyConfiguration.builder();
        if (props.getProperty(PROXY_HOST) != null) {
            String host = props.getProperty(PROXY_HOST);
            String portStr = props.getProperty(PROXY_PORT);
            int port = -1;
            try {
                port = portStr != null ? Integer.parseInt(portStr, 10) : -1;
            }
            catch (NumberFormatException e) {
                this.printWarningMessage(props, PROXY_PORT);
            }
            Properties propsCopy = new Properties();
            for (String key : props.stringPropertyNames()) {
                propsCopy.setProperty(key, props.getProperty(key));
            }
            if (propsCopy.getProperty(PROXY_PROTOCOL) != null) {
                propsCopy.setProperty(PROTOCOL, props.getProperty(PROXY_PROTOCOL));
            }
            URI uri = this.getEndpointUri(host, port, propsCopy);
            builder.endpoint(uri);
        }
        if (props.getProperty(PROXY_USERNAME) != null) {
            builder.username(props.getProperty(PROXY_USERNAME));
        }
        if (props.getProperty(PROXY_PASSWORD) != null) {
            builder.password(props.getProperty(PROXY_PASSWORD));
        }
        if (props.getProperty(PROXY_DOMAIN) != null) {
            builder.ntlmDomain(props.getProperty(PROXY_DOMAIN));
        }
        if (props.getProperty(PROXY_WORKSTATION) != null) {
            builder.ntlmWorkstation(props.getProperty(PROXY_WORKSTATION));
        }
        return (ProxyConfiguration)builder.build();
    }

    private void printWarningMessage(Properties props, String propertyName) {
        LOGGER.warn("The '{}' property could not be loaded with this value: {}", (Object)propertyName, (Object)props.getProperty(propertyName));
    }
}

