/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tika.Tika;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3FileChannel
extends AsynchronousFileChannel {
    private final Logger logger;
    private final S3Path path;
    private final Set<? extends OpenOption> options;
    private final AsynchronousFileChannel fileChannel;
    private Path tempFile;
    private final ReadWriteLock readWriteLock;
    private final Lock openCloseLock;
    private final Lock writeReadChannelLock;

    public S3FileChannel(S3Path path, Set<? extends OpenOption> options, ExecutorService executor, boolean tempFileRequired) throws IOException {
        this(path, options, executor, tempFileRequired, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3FileChannel(S3Path path, Set<? extends OpenOption> options, ExecutorService executor, boolean tempFileRequired, Map<String, String> properties) throws IOException {
        block16: {
            this.logger = LoggerFactory.getLogger(S3FileChannel.class);
            this.tempFile = null;
            this.readWriteLock = new ReentrantReadWriteLock();
            this.openCloseLock = this.readWriteLock.writeLock();
            this.writeReadChannelLock = this.readWriteLock.readLock();
            this.openCloseLock.lock();
            this.path = path;
            this.options = Collections.unmodifiableSet(new HashSet<OpenOption>(options));
            String headerCacheControlProperty = path.getFileSystem().getRequestHeaderCacheControlProperty();
            boolean exists = path.getFileSystem().provider().exists(path);
            boolean removeTempFile = false;
            try {
                if (!this.isOpen()) {
                    if (exists && this.options.contains(StandardOpenOption.CREATE_NEW)) {
                        throw new FileAlreadyExistsException(String.format("The target already exists: %s", path));
                    }
                    if (!(exists || this.options.contains(StandardOpenOption.CREATE_NEW) || this.options.contains(StandardOpenOption.CREATE))) {
                        throw new NoSuchFileException(String.format("The target does not exist: %s", path));
                    }
                    HashSet<? extends OpenOption> fileChannelOptions = new HashSet<OpenOption>(this.options);
                    fileChannelOptions.remove(StandardOpenOption.CREATE_NEW);
                    if (tempFileRequired) {
                        String key = path.getKey();
                        this.tempFile = Files.createTempFile("temp-s3-", key.replaceAll("/", "_"), new FileAttribute[0]);
                        removeTempFile = true;
                        if (exists) {
                            S3Client client = path.getFileSystem().getClient();
                            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(path.getBucketName()).key(key).build();
                            try (ResponseInputStream byteStream = client.getObject(request);){
                                Files.copy((InputStream)byteStream, this.tempFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                            removeTempFile = false;
                        }
                        this.fileChannel = AsynchronousFileChannel.open(this.tempFile.toAbsolutePath(), fileChannelOptions, executor, new FileAttribute[0]);
                        break block16;
                    }
                    this.tempFile = null;
                    this.fileChannel = AsynchronousFileChannel.open((Path)path, fileChannelOptions, executor, new FileAttribute[0]);
                    break block16;
                }
                throw new FileAlreadyExistsException(String.format("Tried to open already opened channel for path %s", path));
            }
            finally {
                this.openCloseLock.unlock();
                if (removeTempFile) {
                    Files.deleteIfExists(this.tempFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Integer> read(ByteBuffer dst, long position) {
        this.writeReadChannelLock.lock();
        try {
            if (this.isOpen()) {
                Future<Integer> future = this.fileChannel.read(dst, position);
                return future;
            }
            CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(0);
            return completableFuture;
        }
        finally {
            this.writeReadChannelLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void read(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.writeReadChannelLock.lock();
        try {
            if (this.isOpen()) {
                this.fileChannel.read(dst, position, attachment, handler);
            }
        }
        finally {
            this.writeReadChannelLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Integer> write(ByteBuffer src, long position) {
        this.writeReadChannelLock.lock();
        try {
            if (this.isOpen()) {
                Future<Integer> future = this.fileChannel.write(src, position);
                return future;
            }
            CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(0);
            return completableFuture;
        }
        finally {
            this.writeReadChannelLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void write(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.writeReadChannelLock.lock();
        try {
            if (this.isOpen()) {
                this.fileChannel.write(src, position, attachment, handler);
            }
        }
        finally {
            this.writeReadChannelLock.unlock();
        }
    }

    @Override
    public long size() throws IOException {
        return this.fileChannel.size();
    }

    @Override
    public AsynchronousFileChannel truncate(long size) throws IOException {
        return this.fileChannel.truncate(size);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.fileChannel.force(metaData);
    }

    @Override
    public Future<FileLock> lock(long position, long size, boolean shared) {
        return this.fileChannel.lock(position, size, shared);
    }

    @Override
    public <A> void lock(long position, long size, boolean shared, A attachment, CompletionHandler<FileLock, ? super A> handler) {
        this.fileChannel.lock(position, size, shared, attachment, handler);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.fileChannel.tryLock(position, size, shared);
    }

    @Override
    public boolean isOpen() {
        return this.fileChannel != null && this.fileChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.openCloseLock.lock();
        try {
            if (this.isOpen()) {
                this.fileChannel.force(true);
                this.fileChannel.close();
                if (this.tempFile != null && Files.exists(this.tempFile, new LinkOption[0])) {
                    if (!this.options.contains(StandardOpenOption.READ)) {
                        this.sync();
                    }
                    Files.delete(this.tempFile);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.info("Tried to close already closed channel for path {}.", (Object)this.path);
            }
        }
        finally {
            this.openCloseLock.unlock();
        }
    }

    protected void sync() throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(this.tempFile, new OpenOption[0]));){
            PutObjectRequest.Builder builder = PutObjectRequest.builder();
            long length = Files.size(this.tempFile);
            builder.bucket(this.path.getBucketName()).key(this.path.getKey()).contentLength(Long.valueOf(length)).contentType(new Tika().detect((InputStream)stream, this.path.getFileName().toString()));
            S3Client client = this.path.getFileSystem().getClient();
            client.putObject((PutObjectRequest)builder.build(), RequestBody.fromInputStream((InputStream)stream, (long)length));
        }
    }
}

