/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.carlspring.cloud.storage.s3fs.S3AccessControlList;
import org.carlspring.cloud.storage.s3fs.S3ClientFactory;
import org.carlspring.cloud.storage.s3fs.S3Factory;
import org.carlspring.cloud.storage.s3fs.S3FileChannel;
import org.carlspring.cloud.storage.s3fs.S3FileSystem;
import org.carlspring.cloud.storage.s3fs.S3FileSystemConfigurationException;
import org.carlspring.cloud.storage.s3fs.S3FilteredIterator;
import org.carlspring.cloud.storage.s3fs.S3OutputStream;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.carlspring.cloud.storage.s3fs.S3SeekableByteChannel;
import org.carlspring.cloud.storage.s3fs.attribute.S3BasicFileAttributeView;
import org.carlspring.cloud.storage.s3fs.attribute.S3BasicFileAttributes;
import org.carlspring.cloud.storage.s3fs.attribute.S3PosixFileAttributeView;
import org.carlspring.cloud.storage.s3fs.attribute.S3PosixFileAttributes;
import org.carlspring.cloud.storage.s3fs.util.AttributesUtils;
import org.carlspring.cloud.storage.s3fs.util.S3Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.util.Mimetype;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.StringUtils;

public class S3FileSystemProvider
extends FileSystemProvider {
    public static final String CHARSET_KEY = "s3fs.charset";
    public static final String S3_FACTORY_CLASS = "s3fs.amazon.s3.factory.class";
    private static volatile ConcurrentMap<String, S3FileSystem> fileSystems = new ConcurrentHashMap<String, S3FileSystem>();
    private static final List<String> PROPS_TO_OVERLOAD = Arrays.asList("s3fs.access.key", "s3fs.secret.key", "s3fs.cache.attributes.ttl", "s3fs.cache.attributes.size", "s3fs.request.metric.collector.class", "s3fs.connection.timeout", "s3fs.max.connections", "s3fs.max.retry.error", "s3fs.protocol", "s3fs.proxy.domain", "s3fs.proxy.host", "s3fs.proxy.password", "s3fs.proxy.port", "s3fs.proxy.username", "s3fs.proxy.workstation", "s3fs.region", "s3fs.socket.send.buffer.size.hint", "s3fs.socket.receive.buffer.size.hint", "s3fs.socket.timeout", "s3fs.user.agent", "s3fs.amazon.s3.factory.class", "s3fs.signer.override", "s3fs.path.style.access");
    private static final int MAX_OBJECT_PER_REQUEST = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(S3FileSystemProvider.class);
    private final S3Utils s3Utils = new S3Utils();

    @Override
    public String getScheme() {
        return "s3";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.validateUri(uri);
        Properties props = this.getProperties(uri, env);
        this.validateProperties(props);
        String key = this.getFileSystemKey(uri, props);
        if (fileSystems.containsKey(key)) {
            String safeName = uri.getScheme() + "://";
            String userInfo = uri.getUserInfo();
            if (userInfo != null) {
                safeName = safeName + uri.getUserInfo().split(":")[0] + ":__REDACTED__@";
            }
            safeName = safeName + uri.getHost() + (uri.getPort() > -1 ? ":" + uri.getPort() : "") + uri.getPath();
            throw new FileSystemAlreadyExistsException("File system " + safeName + " already exists");
        }
        S3FileSystem fileSystem = this.createFileSystem(uri, props);
        fileSystems.put(fileSystem.getKey(), fileSystem);
        return fileSystem;
    }

    private void validateProperties(Properties props) {
        Preconditions.checkArgument((props.getProperty("s3fs.access.key") == null && props.getProperty("s3fs.secret.key") == null || props.getProperty("s3fs.access.key") != null && props.getProperty("s3fs.secret.key") != null ? 1 : 0) != 0, (String)"%s and %s should both be provided or should both be omitted", (Object)"s3fs.access.key", (Object)"s3fs.secret.key");
    }

    private Properties getProperties(URI uri, Map<String, ?> env) {
        Properties props = this.loadAmazonProperties();
        this.addEnvProperties(props, env);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] keys = userInfo.split(":");
            props.setProperty("s3fs.access.key", keys[0]);
            if (keys.length > 1) {
                props.setProperty("s3fs.secret.key", keys[1]);
            }
        }
        return props;
    }

    private String getFileSystemKey(URI uri) {
        return this.getFileSystemKey(uri, this.getProperties(uri, null));
    }

    protected String getFileSystemKey(URI uri, Properties props) {
        String uriString = uri.toString().replaceAll("s3://", "");
        String authority = null;
        int authoritySeparator = uriString.indexOf("@");
        if (authoritySeparator > 0) {
            authority = uriString.substring(0, authoritySeparator);
        }
        if (authority != null) {
            String host = uriString.substring(uriString.indexOf("@") + 1);
            int lastPath = host.indexOf("/");
            if (lastPath > -1) {
                host = host.substring(0, lastPath);
            }
            if (host.length() == 0) {
                host = "s3.amazonaws.com";
            }
            return authority + "@" + host;
        }
        String accessKey = (String)props.get("s3fs.access.key");
        return (accessKey != null ? accessKey + "@" : "") + (uri.getHost() != null ? uri.getHost() : "s3.amazonaws.com");
    }

    protected void validateUri(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkArgument((boolean)uri.getScheme().equals(this.getScheme()), (String)"uri scheme must be 's3': '%s'", (Object)uri);
    }

    protected void addEnvProperties(Properties props, Map<String, ?> env) {
        if (env == null) {
            env = new HashMap();
        }
        for (String string : PROPS_TO_OVERLOAD) {
            this.overloadProperty(props, env, string);
        }
        for (Map.Entry entry : env.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (PROPS_TO_OVERLOAD.contains(key)) continue;
            props.put(key, value);
        }
    }

    private void overloadProperty(Properties props, Map<String, ?> env, String key) {
        boolean overloaded = this.overloadPropertiesWithEnv(props, env, key);
        if (!overloaded) {
            overloaded = this.overloadPropertiesWithSystemProps(props, key);
        }
        if (!overloaded) {
            this.overloadPropertiesWithSystemEnv(props, key);
        }
    }

    protected boolean overloadPropertiesWithEnv(Properties props, Map<String, ?> env, String key) {
        if (env.get(key) instanceof String) {
            props.setProperty(key, (String)env.get(key));
            return true;
        }
        return false;
    }

    public boolean overloadPropertiesWithSystemProps(Properties props, String key) {
        if (System.getProperty(key) != null) {
            props.setProperty(key, System.getProperty(key));
            return true;
        }
        return false;
    }

    public boolean overloadPropertiesWithSystemEnv(Properties props, String key) {
        if (this.systemGetEnv(key) != null) {
            props.setProperty(key, this.systemGetEnv(key));
            return true;
        }
        return false;
    }

    public String systemGetEnv(String key) {
        return System.getenv(key);
    }

    public FileSystem getFileSystem(URI uri, Map<String, ?> env) {
        this.validateUri(uri);
        Properties props = this.getProperties(uri, env);
        String key = this.getFileSystemKey(uri, props);
        if (fileSystems.containsKey(key)) {
            return (FileSystem)fileSystems.get(key);
        }
        return this.newFileSystem(uri, env);
    }

    @Override
    public S3FileSystem getFileSystem(URI uri) {
        this.validateUri(uri);
        String key = this.getFileSystemKey(uri);
        if (fileSystems.containsKey(key)) {
            return (S3FileSystem)fileSystems.get(key);
        }
        throw new FileSystemNotFoundException("S3 filesystem not yet created. Use newFileSystem() instead");
    }

    private S3Path toS3Path(Path path) {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object)S3Path.class.getName());
        return (S3Path)path;
    }

    @Override
    public Path getPath(URI uri) {
        S3FileSystem fileSystem = this.getFileSystem(uri);
        return fileSystem.getPath(uri.getPath(), new String[0]);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, final DirectoryStream.Filter<? super Path> filter) {
        final S3Path s3Path = this.toS3Path(dir);
        return new DirectoryStream<Path>(){

            @Override
            public void close() {
            }

            @Override
            public Iterator<Path> iterator() {
                return new S3FilteredIterator(s3Path, filter);
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        String key = s3Path.getKey();
        String bucketName = s3Path.getBucketName();
        Preconditions.checkArgument((options.length == 0 ? 1 : 0) != 0, (String)"OpenOptions not yet supported: %s", (Object)ImmutableList.copyOf((Object[])options));
        Preconditions.checkArgument((!key.equals("") ? 1 : 0) != 0, (String)"cannot create InputStream for root directory: %s", (Object)path);
        try {
            S3Client client = s3Path.getFileSystem().getClient();
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
            ResponseInputStream res = client.getObject(request);
            if (res == null) {
                String message = String.format("The specified path is a directory: %s", path);
                throw new IOException(message);
            }
            return res;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                throw new NoSuchFileException(path.toString());
            }
            String message = String.format("Cannot access file: %s", path);
            throw new IOException(message, e);
        }
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (options.length > 0) {
            LinkedHashSet<OpenOption> opts = new LinkedHashSet<OpenOption>(Arrays.asList(options));
            if (opts.contains(StandardOpenOption.APPEND)) {
                return super.newOutputStream(path, options);
            }
            if (opts.contains(StandardOpenOption.READ)) {
                throw new IllegalArgumentException("READ not allowed");
            }
            boolean create = opts.remove(StandardOpenOption.CREATE);
            boolean createNew = opts.remove(StandardOpenOption.CREATE_NEW);
            boolean truncateExisting = opts.remove(StandardOpenOption.TRUNCATE_EXISTING);
            opts.remove(StandardOpenOption.WRITE);
            opts.remove(StandardOpenOption.SPARSE);
            if (!opts.isEmpty()) {
                throw new UnsupportedOperationException(opts.iterator().next() + " not supported");
            }
            this.validateCreateAndTruncateOptions(path, s3Path, create, createNew, truncateExisting);
        }
        Map<String, String> metadata = this.buildMetadataFromPath(path);
        S3FileSystem fileSystem = s3Path.getFileSystem();
        return new S3OutputStream(fileSystem.getClient(), s3Path.toS3ObjectId(), null, metadata, fileSystem.getRequestHeaderCacheControlProperty(), s3Path.getFileAttributesCache());
    }

    private void validateCreateAndTruncateOptions(Path path, S3Path s3Path, boolean create, boolean createNew, boolean truncateExisting) throws FileAlreadyExistsException, NoSuchFileException {
        if (!create || !truncateExisting) {
            if (s3Path.getFileSystem().provider().exists(s3Path)) {
                if (createNew || !truncateExisting) {
                    throw new FileAlreadyExistsException(path.toString());
                }
            } else if (!createNew && !create) {
                throw new NoSuchFileException(path.toString());
            }
        }
    }

    private Map<String, String> buildMetadataFromPath(Path path) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        String contentType = Mimetype.getInstance().getMimetype(path);
        if (!StringUtils.isEmpty((CharSequence)contentType)) {
            metadata.put("Content-Type", contentType);
        }
        return metadata;
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        return new S3SeekableByteChannel(s3Path, options, true);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        return new S3FileChannel(s3Path, options, executor, true);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(dir);
        S3Client client = s3Path.getFileSystem().getClient();
        Preconditions.checkArgument((attrs.length == 0 ? 1 : 0) != 0, (String)"attrs not yet supported: %s", (Object)ImmutableList.copyOf((Object[])attrs));
        if (this.exists(s3Path)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", s3Path));
        }
        Bucket bucket = s3Path.getFileStore().getBucket();
        String bucketName = s3Path.getBucketName();
        if (bucket == null) {
            CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
            client.createBucket(request);
        }
        String directoryKey = s3Path.getKey().endsWith("/") ? s3Path.getKey() : s3Path.getKey() + "/";
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(directoryKey).cacheControl(s3Path.getFileSystem().getRequestHeaderCacheControlProperty()).contentLength(Long.valueOf(0L)).contentType("application/x-directory").build();
        client.putObject(request, RequestBody.empty());
        s3Path.getFileAttributesCache().invalidate(s3Path);
    }

    @Override
    public void delete(Path path) throws IOException {
        S3Path rootPath = this.toS3Path(path);
        S3Client client = rootPath.getFileSystem().getClient();
        String bucketName = rootPath.getBucketName();
        LinkedList<Deque<S3Path>> s3Paths = this.getPathsByBatch(rootPath);
        for (Deque deque : s3Paths) {
            this.deleteBatch(client, deque, bucketName);
        }
    }

    private void deleteBatch(S3Client client, Deque<S3Path> batch, String bucketName) throws IOException {
        ArrayList<ObjectIdentifier> objectIdentifiers = new ArrayList<ObjectIdentifier>(batch.size() * 2);
        for (S3Path s3Path : batch) {
            objectIdentifiers.add((ObjectIdentifier)ObjectIdentifier.builder().key(s3Path.getKey()).build());
            objectIdentifiers.add((ObjectIdentifier)ObjectIdentifier.builder().key(s3Path.getKey() + '/').build());
        }
        DeleteObjectsRequest multiObjectDeleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(objectIdentifiers).build()).build();
        try {
            client.deleteObjects(multiObjectDeleteRequest);
            for (S3Path path : batch) {
                path.getFileAttributesCache().invalidate(path);
            }
        }
        catch (SdkException sdkException) {
            throw new IOException(sdkException);
        }
    }

    private LinkedList<Deque<S3Path>> getPathsByBatch(S3Path path) throws IOException {
        LinkedList<S3Path> allPaths = new LinkedList<S3Path>();
        this.visitAllFiles(path, allPaths);
        return this.splitByBatchWithOrder(allPaths, 1000);
    }

    private <T> LinkedList<Deque<T>> splitByBatchWithOrder(List<T> list, int maxSize) {
        LinkedList<Deque<T>> pathsByBatch = new LinkedList<Deque<T>>();
        if (!list.isEmpty()) {
            ArrayDeque<T> deque = new ArrayDeque<T>();
            for (T t : list) {
                if (deque.size() < maxSize) {
                    deque.push(t);
                    continue;
                }
                pathsByBatch.add(deque);
                deque = new ArrayDeque();
            }
            pathsByBatch.add(deque);
        }
        return pathsByBatch;
    }

    private void visitAllFiles(Path path, LinkedList<S3Path> paths) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (Files.notExists(s3Path, new LinkOption[0])) {
            LOGGER.warn("Deleting {} was skipped because the path was not found.", (Object)s3Path);
        } else {
            paths.add(s3Path);
            if (Files.isDirectory(s3Path, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(s3Path);){
                    for (Path child : stream) {
                        this.visitAllFiles(child, paths);
                    }
                }
                catch (SecurityException e) {
                    LOGGER.warn("Deleting {} was skipped because the path could not be read-accessed.", (Object)s3Path);
                }
            }
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        if (this.isSameFile(source, target)) {
            return;
        }
        S3Path s3Source = this.toS3Path(source);
        S3Path s3Target = this.toS3Path(target);
        Preconditions.checkArgument((!Files.isDirectory(source, new LinkOption[0]) ? 1 : 0) != 0, (String)"copying directories is not yet supported: %s", (Object)source);
        Preconditions.checkArgument((!Files.isDirectory(target, new LinkOption[0]) ? 1 : 0) != 0, (String)"copying directories is not yet supported: %s", (Object)target);
        ImmutableSet actualOptions = ImmutableSet.copyOf((Object[])options);
        this.verifySupportedOptions((Set)EnumSet.of(StandardCopyOption.REPLACE_EXISTING), (Set)actualOptions);
        if (!actualOptions.contains((Object)StandardCopyOption.REPLACE_EXISTING) && this.exists(s3Target)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", target));
        }
        String bucketNameOrigin = s3Source.getBucketName();
        String keySource = s3Source.getKey();
        String bucketNameTarget = s3Target.getBucketName();
        String keyTarget = s3Target.getKey();
        S3Client client = s3Source.getFileSystem().getClient();
        String encodedUrl = this.encodeUrl(bucketNameOrigin, keySource);
        CopyObjectRequest request = (CopyObjectRequest)CopyObjectRequest.builder().copySource(encodedUrl).cacheControl(s3Target.getFileSystem().getRequestHeaderCacheControlProperty()).destinationBucket(bucketNameTarget).destinationKey(keyTarget).build();
        client.copyObject(request);
        s3Source.getFileAttributesCache().invalidate(s3Source);
        s3Source.getFileAttributesCache().invalidate(s3Target);
    }

    private String encodeUrl(String bucketNameOrigin, String keySource) throws UnsupportedEncodingException {
        String encodedUrl;
        try {
            encodedUrl = URLEncoder.encode(bucketNameOrigin + "/" + keySource, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("URL could not be encoded: " + e.getMessage());
        }
        return encodedUrl;
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        if (options != null && Arrays.asList(options).contains(StandardCopyOption.ATOMIC_MOVE)) {
            throw new AtomicMoveNotSupportedException(source.toString(), target.toString(), "Atomic not supported");
        }
        this.copy(source, target, options);
        this.delete(source);
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) {
        return path1.isAbsolute() && path2.isAbsolute() && path1.equals(path2);
    }

    @Override
    public boolean isHidden(Path path) {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        return this.toS3Path(path).getFileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"path must be absolute: %s", (Object)s3Path);
        if (!this.exists(s3Path)) {
            throw new NoSuchFileException(this.toString());
        }
        if (modes.length > 0) {
            S3Object s3Object = this.s3Utils.getS3Object(s3Path);
            String key = s3Object.key();
            String bucket = s3Path.getBucketName();
            S3AccessControlList accessControlList = new S3AccessControlList(bucket, key);
            accessControlList.checkAccess(modes);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        S3Path s3Path = this.toS3Path(path);
        if (type == BasicFileAttributeView.class) {
            return (V)new S3BasicFileAttributeView(s3Path);
        }
        if (type == PosixFileAttributeView.class) {
            return (V)new S3PosixFileAttributeView(s3Path);
        }
        if (type == null) {
            throw new NullPointerException("Type is mandatory");
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        try {
            S3Path s3Path = this.toS3Path(path);
            if (type == BasicFileAttributes.class || type == S3BasicFileAttributes.class || type == PosixFileAttributes.class || type == S3PosixFileAttributes.class) {
                S3BasicFileAttributes attrs = s3Path.getFileAttributesCache().get(s3Path, type);
                if (attrs == null) {
                    throw new NoSuchFileException(path.toString());
                }
                return (A)((BasicFileAttributes)type.cast(attrs));
            }
        }
        catch (CompletionException e) {
            throw new IOException(e);
        }
        throw new UnsupportedOperationException(String.format("only %s or %s supported", BasicFileAttributes.class, PosixFileAttributes.class));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes null");
        }
        if (attributes.contains(":") && !attributes.contains("basic:") && !attributes.contains("posix:")) {
            throw new UnsupportedOperationException(String.format("attributes %s are not supported, only basic / posix are supported", attributes));
        }
        if (attributes.equals("*") || attributes.equals("basic:*")) {
            BasicFileAttributes attr = this.readAttributes(path, BasicFileAttributes.class, options);
            return AttributesUtils.fileAttributeToMap(attr);
        }
        if (attributes.equals("posix:*")) {
            PosixFileAttributes attr = this.readAttributes(path, PosixFileAttributes.class, options);
            return AttributesUtils.fileAttributeToMap(attr);
        }
        String[] filters = new String[]{attributes};
        if (attributes.contains(",")) {
            filters = attributes.split(",");
        }
        Class<BasicFileAttributes> filter = BasicFileAttributes.class;
        if (attributes.startsWith("posix:")) {
            filter = PosixFileAttributes.class;
        }
        return AttributesUtils.fileAttributeToMap(this.readAttributes(path, filter, options), filters);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    public S3FileSystem createFileSystem(URI uri, Properties props) {
        String key = this.getFileSystemKey(uri, props);
        S3Client client = this.getS3Client(uri, props);
        String host = uri.getHost();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        return new S3FileSystem(this, key, client, host, properties);
    }

    protected S3Client getS3Client(URI uri, Properties props) {
        S3Factory factory = this.getS3Factory(props);
        return factory.getS3Client(uri, props);
    }

    protected S3Factory getS3Factory(Properties props) {
        if (props.containsKey(S3_FACTORY_CLASS)) {
            String s3FactoryClass = props.getProperty(S3_FACTORY_CLASS);
            try {
                return (S3Factory)Class.forName(s3FactoryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new S3FileSystemConfigurationException("Configuration problem, couldn't instantiate S3Factory (" + s3FactoryClass + "): ", e);
            }
        }
        return new S3ClientFactory();
    }

    public Properties loadAmazonProperties() {
        Properties props = new Properties();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("amazon.properties");){
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private <T> void verifySupportedOptions(Set<? extends T> allowedOptions, Set<? extends T> actualOptions) {
        Sets.SetView unsupported = Sets.difference(actualOptions, allowedOptions);
        Preconditions.checkArgument((boolean)unsupported.isEmpty(), (String)"the following options are not supported: %s", (Object)unsupported);
    }

    private static boolean isBucketRoot(S3Path s3Path) {
        String key = s3Path.getKey();
        return key.equals("") || key.equals("/");
    }

    boolean exists(S3Path path) {
        S3Path s3Path = this.toS3Path(path);
        S3BasicFileAttributes attrs = s3Path.getFileAttributesCache().get(s3Path, BasicFileAttributes.class);
        return attrs != null;
    }

    public void close(S3FileSystem fileSystem) {
        if (fileSystem.getKey() != null && fileSystems.containsKey(fileSystem.getKey())) {
            fileSystem.getFileAttributesCache().invalidateAll();
            fileSystems.remove(fileSystem.getKey());
        }
    }

    public boolean isOpen(S3FileSystem s3FileSystem) {
        return fileSystems.containsKey(s3FileSystem.getKey());
    }

    protected static ConcurrentMap<String, S3FileSystem> getFilesystems() {
        return fileSystems;
    }
}

