/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.carlspring.cloud.storage.s3fs.S3Iterator;
import org.carlspring.cloud.storage.s3fs.S3Path;

public class S3FilteredIterator
implements Iterator<Path> {
    private final S3Iterator s3iterator;
    private final DirectoryStream.Filter<? super Path> filter;
    private Path cursor;
    private boolean cursorIsCurrent;

    public S3FilteredIterator(S3Path s3Path, DirectoryStream.Filter<? super Path> filter) {
        this.filter = filter;
        this.s3iterator = new S3Iterator(s3Path);
        this.clearCursor();
    }

    @Override
    public boolean hasNext() {
        if (!this.cursorIsCurrent) {
            this.findNextFiltered();
        }
        return this.cursorIsCurrent;
    }

    @Override
    public Path next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Path next = this.cursor;
        this.clearCursor();
        return next;
    }

    private void findNextFiltered() {
        try {
            while (this.s3iterator.hasNext()) {
                S3Path next = this.s3iterator.next();
                if (!this.filter.accept(next)) continue;
                this.cursor = next;
                this.cursorIsCurrent = true;
                return;
            }
            this.clearCursor();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void clearCursor() {
        this.cursor = null;
        this.cursorIsCurrent = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

