/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import java.io.Serializable;

public class S3ObjectId
implements Serializable {
    private final String bucket;
    private final String key;

    private S3ObjectId(Builder builder) {
        this.bucket = builder.getBucket();
        this.key = builder.getKey();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder cloneBuilder() {
        return new Builder(this);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ObjectId that = (S3ObjectId)o;
        if (this.getBucket() != null ? !this.getBucket().equals(that.getBucket()) : that.getBucket() != null) {
            return false;
        }
        return this.getKey() != null ? this.getKey().equals(that.getKey()) : that.getKey() == null;
    }

    public int hashCode() {
        int result = this.getBucket() != null ? this.getBucket().hashCode() : 0;
        result = 31 * result + (this.getKey() != null ? this.getKey().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "bucket: " + this.bucket + ", key: " + this.key;
    }

    public static final class Builder {
        private String bucket;
        private String key;

        public Builder() {
        }

        public Builder(S3ObjectId src) {
            this.bucket(src.getBucket());
            this.key(src.getKey());
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getKey() {
            return this.key;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public S3ObjectId build() {
            return new S3ObjectId(this);
        }
    }
}

