/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs.attribute;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PosixFileAttributeView
implements PosixFileAttributeView {
    private static final Logger log = LoggerFactory.getLogger(S3PosixFileAttributeView.class);
    private S3Path s3Path;

    public S3PosixFileAttributeView(S3Path s3Path) {
        this.s3Path = s3Path;
    }

    @Override
    public String name() {
        return "posix";
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        return this.read();
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.read().owner();
    }

    @Override
    public void setOwner(UserPrincipal owner) {
        log.debug(this.getClass() + "#setOwner() is not supported yet.");
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> perms) {
        log.debug(this.getClass() + "#setPermissions() is not supported yet.");
    }

    @Override
    public void setGroup(GroupPrincipal group) {
        log.debug(this.getClass() + "#setGroup() is not supported yet.");
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) {
        log.debug(this.getClass() + "#setTimes() is not supported yet.");
    }

    public PosixFileAttributes read() throws IOException {
        return this.s3Path.getFileSystem().provider().readAttributes((Path)this.s3Path, PosixFileAttributes.class, new LinkOption[0]);
    }
}

