/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs.cache;

import com.github.benmanes.caffeine.cache.Expiry;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.carlspring.cloud.storage.s3fs.attribute.S3BasicFileAttributes;

public class S3FileAttributesCachePolicy
implements Expiry<String, Optional<S3BasicFileAttributes>> {
    private int cacheTTL;

    public S3FileAttributesCachePolicy(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getTTL() {
        return this.cacheTTL;
    }

    public void setTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public long expireAfterCreate(String key, Optional<S3BasicFileAttributes> value, long currentTime) {
        return TimeUnit.MILLISECONDS.toNanos(this.cacheTTL);
    }

    public long expireAfterUpdate(String key, Optional<S3BasicFileAttributes> value, long currentTime, long currentDuration) {
        return TimeUnit.MILLISECONDS.toNanos(this.cacheTTL);
    }

    public long expireAfterRead(String key, Optional<S3BasicFileAttributes> value, long currentTime, long currentDuration) {
        return currentDuration;
    }
}

