/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs.util;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.HashMap;
import java.util.Map;

public abstract class AttributesUtils {
    public static Map<String, Object> fileAttributeToMap(BasicFileAttributes attr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("creationTime", attr.creationTime());
        result.put("fileKey", attr.fileKey());
        result.put("isDirectory", attr.isDirectory());
        result.put("isOther", attr.isOther());
        result.put("isRegularFile", attr.isRegularFile());
        result.put("isSymbolicLink", attr.isSymbolicLink());
        result.put("lastAccessTime", attr.lastAccessTime());
        result.put("lastModifiedTime", attr.lastModifiedTime());
        result.put("size", attr.size());
        if (attr instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttr = (PosixFileAttributes)attr;
            result.put("permissions", posixAttr.permissions());
            result.put("owner", posixAttr.owner());
            result.put("group", posixAttr.group());
        }
        return result;
    }

    public static Map<String, Object> fileAttributeToMap(BasicFileAttributes attr, String[] filters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        block28: for (String filter : filters) {
            filter = filter.replace("basic:", "");
            switch (filter = filter.replace("posix:", "")) {
                case "creationTime": {
                    result.put("creationTime", attr.creationTime());
                    continue block28;
                }
                case "fileKey": {
                    result.put("fileKey", attr.fileKey());
                    continue block28;
                }
                case "isDirectory": {
                    result.put("isDirectory", attr.isDirectory());
                    continue block28;
                }
                case "isOther": {
                    result.put("isOther", attr.isOther());
                    continue block28;
                }
                case "isRegularFile": {
                    result.put("isRegularFile", attr.isRegularFile());
                    continue block28;
                }
                case "isSymbolicLink": {
                    result.put("isSymbolicLink", attr.isSymbolicLink());
                    continue block28;
                }
                case "lastAccessTime": {
                    result.put("lastAccessTime", attr.lastAccessTime());
                    continue block28;
                }
                case "lastModifiedTime": {
                    result.put("lastModifiedTime", attr.lastModifiedTime());
                    continue block28;
                }
                case "size": {
                    result.put("size", attr.size());
                    continue block28;
                }
                case "permissions": {
                    result.put("permissions", ((PosixFileAttributes)attr).permissions());
                    continue block28;
                }
                case "group": {
                    result.put("group", ((PosixFileAttributes)attr).group());
                    continue block28;
                }
                case "owner": {
                    result.put("owner", ((PosixFileAttributes)attr).owner());
                }
            }
        }
        return result;
    }
}

