/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.maven.derby;

import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDerbyMojo
extends AbstractMojo {
    @Parameter(readonly=true, property="project", required=true)
    public MavenProject project;
    @Parameter(property="derby.port")
    int port;
    @Parameter(property="derby.username", defaultValue="derby")
    String username;
    @Parameter(property="derby.password", defaultValue="derby")
    String password;
    @Parameter(property="derby.driver")
    String driver;
    @Parameter(property="derby.url")
    String connectionURL;
    @Parameter(property="derby.url.shutdown", defaultValue="jdbc:derby:;shutdown=true")
    String connectionURLShutdown;
    @Parameter(property="derby.home", defaultValue="${project.build.directory}/derby")
    String derbyHome;
    @Parameter(property="derby.debug", defaultValue="true")
    boolean debugStatements;
    @Parameter(property="derby.skip")
    boolean skip;
    protected NetworkServerControl server;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Derby execution.");
            return;
        }
        this.setupDerby();
        this.doExecute();
    }

    protected void setupDerby() throws MojoExecutionException {
        System.setProperty("derby.system.home", this.getDerbyHome());
        System.setProperty("derby.language.logStatementText", String.valueOf(this.debugStatements));
        try {
            InetAddress localHost = InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
            this.getLog().info((CharSequence)("Initializing Derby server control for " + localHost));
            this.server = new NetworkServerControl(localHost, this.getPort(), this.getUsername(), this.getPassword());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getConnectionURLShutdown() {
        return this.connectionURLShutdown;
    }

    public void setConnectionURLShutdown(String connectionURLShutdown) {
        this.connectionURLShutdown = connectionURLShutdown;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDerbyHome() {
        return this.derbyHome;
    }

    public void setDerbyHome(String derbyHome) {
        this.derbyHome = derbyHome;
    }

    public boolean isDebugStatements() {
        return this.debugStatements;
    }

    public void setDebugStatements(boolean debugStatements) {
        this.debugStatements = debugStatements;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

