/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.maven.derby;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.carlspring.maven.derby.StartDerbyMojo;

@Mojo(name="run", requiresProject=false)
public class RunDerbyMojo
extends StartDerbyMojo {
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            super.doExecute();
            this.getLog().info((CharSequence)"Blocking to wait for connections, use the derby:stop goal to kill.");
            while (true) {
                try {
                    this.server.ping();
                }
                catch (Exception e) {
                    this.getLog().info((CharSequence)"Derby server is not responding to pings, exiting...");
                    return;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            this.getLog().info((CharSequence)"Server polling thread was killed, you should use the @stop goal instead.");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

