/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.maven.derby;

import java.io.PrintWriter;
import java.net.BindException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.carlspring.maven.derby.AbstractDerbyMojo;

@Mojo(name="start", requiresProject=false)
public class StartDerbyMojo
extends AbstractDerbyMojo {
    @Parameter(property="derby.fail.if.already.running", defaultValue="true")
    boolean failIfAlreadyRunning;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            try {
                this.getLog().info((CharSequence)"Starting the Derby server ...");
                this.server.start(new PrintWriter(System.out));
            }
            catch (Exception e) {
                if (e instanceof BindException) {
                    if (this.failIfAlreadyRunning) {
                        throw new MojoExecutionException("Failed to start the Derby server, port already open!", e);
                    }
                    this.getLog().info((CharSequence)"Derby is already running.");
                }
                throw new MojoExecutionException(e.getMessage(), e);
            }
            if (this.server != null) {
                long maxSleepTime = 60000L;
                long sleepTime = 0L;
                boolean pong = false;
                while (!pong && sleepTime < maxSleepTime) {
                    try {
                        this.server.ping();
                        pong = true;
                    }
                    catch (Exception e) {
                        sleepTime += 1000L;
                        Thread.sleep(1000L);
                    }
                }
                if (!pong) {
                    this.getLog().info((CharSequence)"Derby ping-pong: [FAILED]");
                    throw new MojoFailureException("Failed to start the NetworkServerControl. The server did not respond with a pong withing 60 seconds.");
                }
            } else {
                throw new MojoExecutionException("Failed to start the Derby server!");
            }
            this.getLog().info((CharSequence)"Derby ping-pong: [OK]");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public boolean isFailIfAlreadyRunning() {
        return this.failIfAlreadyRunning;
    }

    public void setFailIfAlreadyRunning(boolean failIfAlreadyRunning) {
        this.failIfAlreadyRunning = failIfAlreadyRunning;
    }
}

