/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.maven.derby;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.carlspring.maven.derby.AbstractDerbyMojo;

@Mojo(name="stop", requiresProject=false)
public class StopDerbyMojo
extends AbstractDerbyMojo {
    @Parameter(property="derby.fail.if.already.running", defaultValue="true")
    boolean failIfNotRunning;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            try {
                this.server.ping();
            }
            catch (Exception e) {
                if (this.failIfNotRunning) {
                    throw new MojoExecutionException("Failed to stop the Derby server, no server running!", e);
                }
                this.getLog().error((CharSequence)"Derby server was already stopped.");
                return;
            }
            try {
                DriverManager.getConnection(this.getConnectionURLShutdown());
            }
            catch (SQLException e) {
                if (this.isSuccessfulShutdown(e)) {
                    this.getLog().info((CharSequence)e.getMessage());
                }
                this.getLog().error((CharSequence)e.getMessage());
            }
            this.server.shutdown();
            while (true) {
                try {
                    this.server.ping();
                }
                catch (Exception e) {
                    this.getLog().info((CharSequence)"Derby has stopped!");
                    break;
                }
                Thread.sleep(1000L);
            }
            System.getProperties().remove("derby.system.home");
            this.removeLocks();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private boolean isSuccessfulShutdown(SQLException e) {
        return 50000 == e.getErrorCode() && "XJ015".equals(e.getSQLState());
    }

    private void removeLocks() {
        File dbexLock;
        this.getLog().info((CharSequence)"Removing locks...");
        File dbLock = new File(this.getDerbyHome() + "/db", "db.lck");
        if (dbLock.exists()) {
            this.getLog().debug((CharSequence)(" -> Removing " + dbLock.getAbsolutePath()));
            dbLock.delete();
        }
        if ((dbexLock = new File(this.getDerbyHome() + "/db", "dbex.lck")).exists()) {
            this.getLog().debug((CharSequence)(" -> Removing " + dbexLock.getAbsolutePath()));
            dbexLock.delete();
        }
        this.getLog().info((CharSequence)"Locks removed.");
    }

    public boolean isFailIfNotRunning() {
        return this.failIfNotRunning;
    }

    public void setFailIfNotRunning(boolean failIfNotRunning) {
        this.failIfNotRunning = failIfNotRunning;
    }
}

