/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.lingo;

import com.carrotsearch.hppc.IntIntHashMap;
import java.util.Arrays;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.clustering.lingo.ILabelAssigner;
import org.carrot2.clustering.lingo.LingoProcessingContext;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.util.attribute.Bindable;

@Bindable
public class SimpleLabelAssigner
implements ILabelAssigner {
    @Override
    public void assignLabels(LingoProcessingContext context, DoubleMatrix2D stemCos, IntIntHashMap filteredRowToStemIndex, DoubleMatrix2D phraseCos) {
        PreprocessingContext preprocessingContext = context.preprocessingContext;
        int firstPhraseIndex = preprocessingContext.allLabels.firstPhraseIndex;
        int[] labelsFeatureIndex = preprocessingContext.allLabels.featureIndex;
        int[] mostFrequentOriginalWordIndex = preprocessingContext.allStems.mostFrequentOriginalWordIndex;
        int desiredClusterCount = stemCos.columns();
        int[] candidateStemIndices = new int[desiredClusterCount];
        double[] candidateStemScores = new double[desiredClusterCount];
        int[] candidatePhraseIndices = new int[desiredClusterCount];
        Arrays.fill(candidatePhraseIndices, -1);
        double[] candidatePhraseScores = new double[desiredClusterCount];
        MatrixUtils.maxInColumns(stemCos, candidateStemIndices, candidateStemScores, Functions.ABS);
        if (phraseCos != null) {
            MatrixUtils.maxInColumns(phraseCos, candidatePhraseIndices, candidatePhraseScores, Functions.ABS);
        }
        int[] clusterLabelFeatureIndex = new int[desiredClusterCount];
        double[] clusterLabelScore = new double[desiredClusterCount];
        for (int i = 0; i < desiredClusterCount; ++i) {
            int phraseFeatureIndex = candidatePhraseIndices[i];
            int stemIndex = filteredRowToStemIndex.get(candidateStemIndices[i]);
            double phraseScore = candidatePhraseScores[i];
            if (phraseFeatureIndex >= 0 && phraseScore > candidateStemScores[i]) {
                clusterLabelFeatureIndex[i] = labelsFeatureIndex[phraseFeatureIndex + firstPhraseIndex];
                clusterLabelScore[i] = phraseScore;
                continue;
            }
            clusterLabelFeatureIndex[i] = mostFrequentOriginalWordIndex[stemIndex];
            clusterLabelScore[i] = candidateStemScores[i];
        }
        context.clusterLabelFeatureIndex = clusterLabelFeatureIndex;
        context.clusterLabelScore = clusterLabelScore;
    }
}

