/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="file-resource")
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public final class FileResource
implements IResource {
    private File file;
    @Attribute(name="absolute-path")
    private String info;

    FileResource() {
    }

    public FileResource(File file) {
        this.file = file;
        this.info = file.getAbsolutePath();
    }

    @Override
    public InputStream open() throws IOException {
        return StreamUtils.prefetch(new FileInputStream(this.file));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileResource) {
            return ((FileResource)obj).file.equals(this.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.info;
    }

    @Commit
    void afterDeserialization() {
        this.file = new File(this.info);
    }

    @JsonIgnore
    public File getFile() {
        return this.file;
    }

    @JsonProperty
    private String getAbsolutePath() {
        return this.info;
    }

    public static FileResource valueOf(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        return new FileResource(file);
    }
}

