/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class DictionaryMetadata {
    public static final String ATTR_NAME_SEPARATOR = "fsa.dict.separator";
    public static final String ATTR_NAME_ENCODING = "fsa.dict.encoding";
    public static final String ATTR_NAME_USES_PREFIXES = "fsa.dict.uses-prefixes";
    public static final String ATTR_NAME_USES_INFIXES = "fsa.dict.uses-infixes";
    public final byte separator;
    public final String encoding;
    public final boolean usesPrefixes;
    public final boolean usesInfixes;
    public final Map<String, String> metadata;

    public DictionaryMetadata(char separator, String encoding, boolean usesPrefixes, boolean usesInfixes, Map<String, String> metadata) {
        this.encoding = encoding;
        this.usesPrefixes = usesPrefixes;
        this.usesInfixes = usesInfixes;
        try {
            byte[] separatorBytes = new String(new char[]{separator}).getBytes(encoding);
            if (separatorBytes.length != 1) {
                throw new RuntimeException("Separator character '" + separator + "' must be a single byte after transformation with encoding: " + encoding);
            }
            this.separator = separatorBytes[0];
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding not supported on this VM: " + encoding);
        }
        this.metadata = Collections.unmodifiableMap(new HashMap<String, String>(metadata));
    }

    static DictionaryMetadata fromMap(Properties properties) throws IOException {
        String separator = properties.getProperty(ATTR_NAME_SEPARATOR);
        if (separator == null || separator.length() != 1) {
            throw new IOException("Attribute fsa.dict.separator must be a single character.");
        }
        String encoding = properties.getProperty(ATTR_NAME_ENCODING);
        if (encoding == null || encoding.length() == 0) {
            throw new IOException("Attribute fsa.dict.encoding must be present and non-empty.");
        }
        boolean usesPrefixes = Boolean.valueOf(properties.getProperty(ATTR_NAME_USES_PREFIXES, "false"));
        boolean usesInfixes = Boolean.valueOf(properties.getProperty(ATTR_NAME_USES_INFIXES, "false"));
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            metadata.put(e.getKey().toString(), e.getValue().toString());
        }
        return new DictionaryMetadata(separator.charAt(0), encoding, usesPrefixes, usesInfixes, metadata);
    }
}

