/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.UnsupportedEncodingException;

public final class MorphEncoder {
    private final byte annotationSeparator;
    private static final int MAX_PREFIX_LEN = 3;
    private static final int MAX_INFIX_LEN = 3;
    private static final String UTF8 = "UTF-8";

    public MorphEncoder() {
        this(43);
    }

    public MorphEncoder(byte annotationSeparator) {
        this.annotationSeparator = annotationSeparator;
    }

    public static int commonPrefix(byte[] s1, byte[] s2) {
        int maxLen = Math.min(s1.length, s2.length);
        for (int i = 0; i < maxLen; ++i) {
            if (s1[i] == s2[i]) continue;
            return i;
        }
        return maxLen;
    }

    private static byte[] subsequence(byte[] bytes, int start) {
        byte[] newArray = new byte[bytes.length - start];
        System.arraycopy(bytes, start, newArray, 0, bytes.length - start);
        return newArray;
    }

    private static int copyTo(byte[] dst, int pos, byte[] src) {
        System.arraycopy(src, 0, dst, pos, src.length);
        return src.length;
    }

    private static int copyTo(byte[] dst, int pos, byte src) {
        byte[] single = new byte[]{src};
        System.arraycopy(single, 0, dst, pos, 1);
        return 1;
    }

    public byte[] standardEncode(byte[] wordForm, byte[] wordLemma, byte[] wordTag) {
        int l1 = wordForm.length;
        int prefix = MorphEncoder.commonPrefix(wordForm, wordLemma);
        int len = wordLemma.length - prefix;
        int pos = 0;
        int arrayLen = l1 + len + 3;
        if (wordTag != null) {
            arrayLen += wordTag.length;
        }
        byte[] bytes = new byte[arrayLen];
        pos += MorphEncoder.copyTo(bytes, pos, wordForm);
        pos += MorphEncoder.copyTo(bytes, pos, this.annotationSeparator);
        if (prefix == 0) {
            pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 + 65 & 0xFF));
            pos += MorphEncoder.copyTo(bytes, pos, wordLemma);
        } else {
            pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefix + 65 & 0xFF));
            pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix));
        }
        pos += MorphEncoder.copyTo(bytes, pos, this.annotationSeparator);
        if (wordTag != null) {
            pos += MorphEncoder.copyTo(bytes, pos, wordTag);
        }
        return bytes;
    }

    public byte[] prefixEncode(byte[] wordForm, byte[] wordLemma, byte[] wordTag) {
        int l1 = wordForm.length;
        int prefix = MorphEncoder.commonPrefix(wordForm, wordLemma);
        int arrayLen = l1 + wordLemma.length + 4;
        if (wordTag != null) {
            arrayLen += wordTag.length;
        }
        byte[] bytes = new byte[arrayLen];
        int pos = 0;
        pos += MorphEncoder.copyTo(bytes, pos, wordForm);
        pos += MorphEncoder.copyTo(bytes, pos, this.annotationSeparator);
        if (prefix == 0) {
            int prefixFound = 0;
            int prefix1 = 0;
            int max = Math.min(wordForm.length, 3);
            for (int i = 1; i <= max; ++i) {
                prefix1 = MorphEncoder.commonPrefix(MorphEncoder.subsequence(wordForm, i), wordLemma);
                if (prefix1 <= 2) continue;
                prefixFound = i;
                break;
            }
            if (prefixFound == 0) {
                pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, wordLemma);
            } else {
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(prefixFound + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefixFound - prefix1 + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix1));
            }
        } else {
            pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
            pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefix + 65 & 0xFF));
            pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix));
        }
        pos += MorphEncoder.copyTo(bytes, pos, this.annotationSeparator);
        if (wordTag != null) {
            pos += MorphEncoder.copyTo(bytes, pos, wordTag);
        }
        byte[] finalArray = new byte[pos];
        System.arraycopy(bytes, 0, finalArray, 0, pos);
        return finalArray;
    }

    public byte[] infixEncode(byte[] wordForm, byte[] wordLemma, byte[] wordTag) {
        int i;
        int l1 = wordForm.length;
        int prefixFound = 0;
        int prefix1 = 0;
        int prefix = MorphEncoder.commonPrefix(wordForm, wordLemma);
        int max = Math.min(l1, 3);
        int arrayLen = l1 + wordLemma.length + 5;
        if (wordTag != null) {
            arrayLen += wordTag.length;
        }
        byte[] bytes = new byte[arrayLen];
        int pos = 0;
        pos += MorphEncoder.copyTo(bytes, pos, wordForm);
        pos += MorphEncoder.copyTo(bytes, pos, this.annotationSeparator);
        if (prefix == 0) {
            for (i = 1; i <= max; ++i) {
                prefix1 = MorphEncoder.commonPrefix(MorphEncoder.subsequence(wordForm, i), wordLemma);
                if (prefix1 <= 2) continue;
                prefixFound = i;
                break;
            }
            if (prefixFound == 0) {
                pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, wordLemma);
            } else {
                pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(prefixFound + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefixFound - prefix1 + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix1));
            }
        } else {
            for (i = 1; i <= max; ++i) {
                prefix1 = MorphEncoder.commonPrefix(MorphEncoder.subsequence(wordForm, i), wordLemma);
                if (prefix1 <= 2) continue;
                prefixFound = i;
                break;
            }
            int prefix2 = 0;
            int infixFound = 0;
            int max2 = Math.min(l1 - prefix, 3);
            for (int i2 = 1; i2 <= max2; ++i2) {
                prefix2 = MorphEncoder.commonPrefix(MorphEncoder.subsequence(wordForm, prefix + i2), MorphEncoder.subsequence(wordLemma, prefix));
                if (prefix2 <= 2) continue;
                infixFound = i2;
                break;
            }
            if (prefixFound > infixFound) {
                if (prefixFound > 0 && prefix1 > prefix) {
                    pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                    pos += MorphEncoder.copyTo(bytes, pos, (byte)(prefixFound + 65 & 0xFF));
                    pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefixFound - prefix1 + 65 & 0xFF));
                    pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix1));
                } else {
                    pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                    pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                    pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefix + 65 & 0xFF));
                    pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix));
                }
            } else if (infixFound > 0 && prefix2 > 0) {
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(prefix + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(infixFound + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefix - prefix2 - infixFound + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix + prefix2));
            } else {
                pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                pos += MorphEncoder.copyTo(bytes, pos, (byte)65);
                pos += MorphEncoder.copyTo(bytes, pos, (byte)(l1 - prefix + 65 & 0xFF));
                pos += MorphEncoder.copyTo(bytes, pos, MorphEncoder.subsequence(wordLemma, prefix));
            }
        }
        pos += MorphEncoder.copyTo(bytes, pos, this.annotationSeparator);
        if (wordTag != null) {
            pos += MorphEncoder.copyTo(bytes, pos, wordTag);
        }
        byte[] finalArray = new byte[pos];
        System.arraycopy(bytes, 0, finalArray, 0, pos);
        return finalArray;
    }

    protected static String asString(byte[] str, String encoding) {
        try {
            return new String(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public String standardEncodeUTF8(String wordForm, String wordLemma, String wordTag) throws UnsupportedEncodingException {
        return MorphEncoder.asString(this.standardEncode(wordForm.getBytes(UTF8), wordLemma.getBytes(UTF8), wordTag.getBytes(UTF8)), UTF8);
    }

    public String prefixEncodeUTF8(String wordForm, String wordLemma, String wordTag) throws UnsupportedEncodingException {
        return MorphEncoder.asString(this.prefixEncode(wordForm.getBytes(UTF8), wordLemma.getBytes(UTF8), wordTag.getBytes(UTF8)), UTF8);
    }

    public String infixEncodeUTF8(String wordForm, String wordLemma, String wordTag) throws UnsupportedEncodingException {
        return MorphEncoder.asString(this.infixEncode(wordForm.getBytes(UTF8), wordLemma.getBytes(UTF8), wordTag.getBytes(UTF8)), UTF8);
    }
}

