/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import morfologik.stemming.EncoderType;

public enum DictionaryAttribute {
    SEPARATOR("fsa.dict.separator"){

        @Override
        public Character fromString(String separator) {
            if (separator == null || separator.length() != 1) {
                throw new IllegalArgumentException("Attribute " + this.propertyName + " must be a single character.");
            }
            char charValue = separator.charAt(0);
            if (Character.isHighSurrogate(charValue) || Character.isLowSurrogate(charValue)) {
                throw new IllegalArgumentException("Field separator character cannot be part of a surrogate pair: " + separator);
            }
            return Character.valueOf(charValue);
        }
    }
    ,
    ENCODING("fsa.dict.encoding"){

        @Override
        public Charset fromString(String charsetName) {
            return Charset.forName(charsetName);
        }
    }
    ,
    IGNORE_NUMBERS("fsa.dict.speller.ignore-numbers"){

        @Override
        public Boolean fromString(String value) {
            return DictionaryAttribute.booleanValue(value);
        }
    }
    ,
    IGNORE_PUNCTUATION("fsa.dict.speller.ignore-punctuation"){

        @Override
        public Boolean fromString(String value) {
            return DictionaryAttribute.booleanValue(value);
        }
    }
    ,
    IGNORE_CAMEL_CASE("fsa.dict.speller.ignore-camel-case"){

        @Override
        public Boolean fromString(String value) {
            return DictionaryAttribute.booleanValue(value);
        }
    }
    ,
    IGNORE_ALL_UPPERCASE("fsa.dict.speller.ignore-all-uppercase"){

        @Override
        public Boolean fromString(String value) {
            return DictionaryAttribute.booleanValue(value);
        }
    }
    ,
    IGNORE_DIACRITICS("fsa.dict.speller.ignore-diacritics"){

        @Override
        public Boolean fromString(String value) {
            return DictionaryAttribute.booleanValue(value);
        }
    }
    ,
    CONVERT_CASE("fsa.dict.speller.convert-case"){

        @Override
        public Boolean fromString(String value) {
            return DictionaryAttribute.booleanValue(value);
        }
    }
    ,
    RUN_ON_WORDS("fsa.dict.speller.runon-words"){

        @Override
        public Boolean fromString(String value) {
            return DictionaryAttribute.booleanValue(value);
        }
    }
    ,
    LOCALE("fsa.dict.speller.locale"){

        @Override
        public Locale fromString(String value) {
            return new Locale(value);
        }
    }
    ,
    ENCODER("fsa.dict.encoder"){

        public EncoderType fromString(String value) {
            return EncoderType.valueOf(value.toUpperCase(Locale.ROOT));
        }
    }
    ,
    REPLACEMENT_PAIRS("fsa.dict.speller.replacement-pairs"){

        @Override
        public Map<String, List<String>> fromString(String value) throws IllegalArgumentException {
            String[] replacements;
            HashMap<String, List<String>> replacementPairs = new HashMap<String, List<String>>();
            for (String stringPair : replacements = value.split(",\\s*")) {
                String[] twoStrings = stringPair.trim().split(" ");
                if (twoStrings.length == 2) {
                    if (!replacementPairs.containsKey(twoStrings[0])) {
                        ArrayList<String> strList = new ArrayList<String>();
                        strList.add(twoStrings[1]);
                        replacementPairs.put(twoStrings[0], strList);
                        continue;
                    }
                    ((List)replacementPairs.get(twoStrings[0])).add(twoStrings[1]);
                    continue;
                }
                throw new IllegalArgumentException("Attribute " + this.propertyName + " is not in the proper format: " + value);
            }
            return replacementPairs;
        }
    }
    ,
    EQUIVALENT_CHARS("fsa.dict.speller.equivalent-chars"){

        @Override
        public Map<Character, List<Character>> fromString(String value) throws IllegalArgumentException {
            String[] eqChars;
            HashMap<Character, List<Character>> equivalentCharacters = new HashMap<Character, List<Character>>();
            for (String characterPair : eqChars = value.split(",\\s*")) {
                char toChar;
                char fromChar;
                String[] twoChars = characterPair.trim().split(" ");
                if (twoChars.length == 2 && twoChars[0].length() == 1 && twoChars[1].length() == 1) {
                    fromChar = twoChars[0].charAt(0);
                    toChar = twoChars[1].charAt(0);
                    if (!equivalentCharacters.containsKey(Character.valueOf(fromChar))) {
                        ArrayList chList = new ArrayList();
                        equivalentCharacters.put(Character.valueOf(fromChar), chList);
                    }
                } else {
                    throw new IllegalArgumentException("Attribute " + this.propertyName + " is not in the proper format: " + value);
                }
                ((List)equivalentCharacters.get(Character.valueOf(fromChar))).add(Character.valueOf(toChar));
            }
            return equivalentCharacters;
        }
    }
    ,
    LICENSE("fsa.dict.license"),
    AUTHOR("fsa.dict.author"),
    CREATION_DATE("fsa.dict.created");

    public final String propertyName;
    private static final Map<String, DictionaryAttribute> attrsByPropertyName;

    public Object fromString(String value) throws IllegalArgumentException {
        return value;
    }

    public static DictionaryAttribute fromPropertyName(String propertyName) {
        DictionaryAttribute value = attrsByPropertyName.get(propertyName);
        if (value == null) {
            throw new IllegalArgumentException("No attribute for property: " + propertyName);
        }
        return value;
    }

    private DictionaryAttribute(String propertyName) {
        this.propertyName = propertyName;
    }

    private static Boolean booleanValue(String value) {
        if ("true".equals(value = value.toLowerCase()) || "yes".equals(value) || "on".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value) || "no".equals(value) || "off".equals(value)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Not a boolean value: " + value);
    }

    static {
        attrsByPropertyName = new HashMap<String, DictionaryAttribute>();
        for (DictionaryAttribute attr : DictionaryAttribute.values()) {
            if (attrsByPropertyName.put(attr.propertyName, attr) == null) continue;
            throw new RuntimeException("Duplicate property key for: " + (Object)((Object)attr));
        }
    }
}

