/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import morfologik.stemming.DictionaryAttribute;
import morfologik.stemming.DictionaryMetadataBuilder;
import morfologik.stemming.EncoderType;

public final class DictionaryMetadata {
    private static Map<DictionaryAttribute, String> DEFAULT_ATTRIBUTES = new DictionaryMetadataBuilder().separator('+').encoder(EncoderType.SUFFIX).ignorePunctuation().ignoreNumbers().ignoreCamelCase().ignoreAllUppercase().ignoreDiacritics().convertCase().supportRunOnWords().toMap();
    private static EnumSet<DictionaryAttribute> REQUIRED_ATTRIBUTES = EnumSet.of(DictionaryAttribute.SEPARATOR, DictionaryAttribute.ENCODING);
    private byte separator;
    private char separatorChar;
    private String encoding;
    private Charset charset;
    private Locale locale = Locale.getDefault();
    private Map<String, List<String>> replacementPairs = Collections.emptyMap();
    private Map<Character, List<Character>> equivalentChars = Collections.emptyMap();
    private final EnumMap<DictionaryAttribute, String> attributes;
    private final EnumMap<DictionaryAttribute, Boolean> boolAttributes = new EnumMap(DictionaryAttribute.class);
    private EncoderType encoderType;

    public Map<DictionaryAttribute, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, List<String>> getReplacementPairs() {
        return this.replacementPairs;
    }

    public Map<Character, List<Character>> getEquivalentChars() {
        return this.equivalentChars;
    }

    public boolean isIgnoringPunctuation() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_PUNCTUATION);
    }

    public boolean isIgnoringNumbers() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_NUMBERS);
    }

    public boolean isIgnoringCamelCase() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_CAMEL_CASE);
    }

    public boolean isIgnoringAllUppercase() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_ALL_UPPERCASE);
    }

    public boolean isIgnoringDiacritics() {
        return this.boolAttributes.get((Object)DictionaryAttribute.IGNORE_DIACRITICS);
    }

    public boolean isConvertingCase() {
        return this.boolAttributes.get((Object)DictionaryAttribute.CONVERT_CASE);
    }

    public boolean isSupportingRunOnWords() {
        return this.boolAttributes.get((Object)DictionaryAttribute.RUN_ON_WORDS);
    }

    public DictionaryMetadata(Map<DictionaryAttribute, String> userAttrs) {
        this.attributes = new EnumMap(DictionaryAttribute.class);
        this.attributes.putAll(userAttrs);
        EnumMap<DictionaryAttribute, String> attrs = new EnumMap<DictionaryAttribute, String>(DEFAULT_ATTRIBUTES);
        attrs.putAll(userAttrs);
        EnumSet<DictionaryAttribute> requiredAttributes = EnumSet.copyOf(REQUIRED_ATTRIBUTES);
        block12: for (Map.Entry<DictionaryAttribute, String> e : attrs.entrySet()) {
            requiredAttributes.remove((Object)e.getKey());
            Object value = e.getKey().fromString(e.getValue());
            switch (e.getKey()) {
                case ENCODING: {
                    this.encoding = e.getValue();
                    if (!Charset.isSupported(this.encoding)) {
                        throw new IllegalArgumentException("Encoding not supported on this JVM: " + this.encoding);
                    }
                    this.charset = (Charset)value;
                    continue block12;
                }
                case SEPARATOR: {
                    this.separatorChar = ((Character)value).charValue();
                    continue block12;
                }
                case LOCALE: {
                    this.locale = (Locale)value;
                    continue block12;
                }
                case ENCODER: {
                    this.encoderType = (EncoderType)((Object)value);
                    continue block12;
                }
                case REPLACEMENT_PAIRS: {
                    Map gvalue;
                    this.replacementPairs = gvalue = (Map)value;
                    continue block12;
                }
                case EQUIVALENT_CHARS: {
                    Map gvalue;
                    this.equivalentChars = gvalue = (Map)value;
                    continue block12;
                }
                case IGNORE_PUNCTUATION: 
                case IGNORE_NUMBERS: 
                case IGNORE_CAMEL_CASE: 
                case IGNORE_ALL_UPPERCASE: 
                case IGNORE_DIACRITICS: 
                case CONVERT_CASE: 
                case RUN_ON_WORDS: {
                    this.boolAttributes.put((DictionaryAttribute)((Enum)e.getKey()), (Boolean)value);
                    continue block12;
                }
                case AUTHOR: 
                case LICENSE: 
                case CREATION_DATE: {
                    e.getKey().fromString(e.getValue());
                    continue block12;
                }
            }
            throw new RuntimeException("Unexpected code path (attribute should be handled but is not): " + (Object)((Object)e.getKey()));
        }
        if (!requiredAttributes.isEmpty()) {
            throw new IllegalArgumentException("At least one the required attributes was not provided: " + requiredAttributes.toString());
        }
        CharsetEncoder encoder = this.getEncoder();
        try {
            ByteBuffer encoded = encoder.encode(CharBuffer.wrap(new char[]{this.separatorChar}));
            if (encoded.remaining() > 1) {
                throw new IllegalArgumentException("Separator character is not a single byte in encoding " + this.encoding + ": " + this.separatorChar);
            }
            this.separator = encoded.get();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Separator character cannot be converted to a byte in " + this.encoding + ": " + this.separatorChar, e);
        }
    }

    public CharsetDecoder getDecoder() {
        try {
            return this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException("FSA's encoding charset is not supported: " + this.encoding);
        }
    }

    public CharsetEncoder getEncoder() {
        try {
            return this.charset.newEncoder();
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException("FSA's encoding charset is not supported: " + this.encoding);
        }
    }

    public EncoderType getEncoderType() {
        return this.encoderType;
    }

    public char getSeparatorAsChar() {
        return this.separatorChar;
    }
}

