/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.WeakHashMap;
import morfologik.fsa.FSA;
import morfologik.stemming.DictionaryAttribute;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.EncoderType;
import morfologik.util.FileUtils;
import morfologik.util.ResourceUtils;

public final class Dictionary {
    public static final String METADATA_FILE_EXTENSION = "info";
    public final FSA fsa;
    public final DictionaryMetadata metadata;
    public static final WeakHashMap<String, Dictionary> defaultDictionaries = new WeakHashMap();

    public Dictionary(FSA fsa, DictionaryMetadata metadata) {
        this.fsa = fsa;
        this.metadata = metadata;
    }

    public static Dictionary read(File fsaFile) throws IOException {
        File featuresFile = new File(fsaFile.getParent(), Dictionary.getExpectedFeaturesName(fsaFile.getName()));
        FileUtils.assertExists((File)featuresFile, (boolean)true, (boolean)false);
        return Dictionary.readAndClose(new FileInputStream(fsaFile), new FileInputStream(featuresFile));
    }

    public static Dictionary read(URL fsaURL) throws IOException {
        String fsa = fsaURL.toExternalForm();
        String features = Dictionary.getExpectedFeaturesName(fsa);
        return Dictionary.readAndClose(ResourceUtils.openInputStream((String)fsa), ResourceUtils.openInputStream((String)features));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary readAndClose(InputStream fsaData, InputStream featuresData) throws IOException {
        Dictionary dictionary;
        try {
            HashMap<DictionaryAttribute, String> map = new HashMap<DictionaryAttribute, String>();
            Properties properties = new Properties();
            properties.load(new InputStreamReader(featuresData, "UTF-8"));
            if (!properties.containsKey(DictionaryAttribute.ENCODER.propertyName)) {
                boolean usesSuffixes = Boolean.valueOf(properties.getProperty("fsa.dict.uses-suffixes", "true"));
                boolean usesPrefixes = Boolean.valueOf(properties.getProperty("fsa.dict.uses-prefixes", "false"));
                boolean usesInfixes = Boolean.valueOf(properties.getProperty("fsa.dict.uses-infixes", "false"));
                if (usesInfixes) {
                    map.put(DictionaryAttribute.ENCODER, EncoderType.INFIX.name());
                } else if (usesPrefixes) {
                    map.put(DictionaryAttribute.ENCODER, EncoderType.PREFIX.name());
                } else if (usesSuffixes) {
                    map.put(DictionaryAttribute.ENCODER, EncoderType.SUFFIX.name());
                } else {
                    map.put(DictionaryAttribute.ENCODER, EncoderType.NONE.name());
                }
                properties.remove("fsa.dict.uses-suffixes");
                properties.remove("fsa.dict.uses-prefixes");
                properties.remove("fsa.dict.uses-infixes");
            }
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(DictionaryAttribute.fromPropertyName(key), properties.getProperty(key));
            }
            DictionaryMetadata features = new DictionaryMetadata(map);
            FSA fsa = FSA.read((InputStream)fsaData);
            dictionary = new Dictionary(fsa, features);
        }
        catch (Throwable throwable) {
            FileUtils.close((Closeable[])new Closeable[]{fsaData, featuresData});
            throw throwable;
        }
        FileUtils.close((Closeable[])new Closeable[]{fsaData, featuresData});
        return dictionary;
    }

    public static String getExpectedFeaturesName(String name) {
        int dotIndex = name.lastIndexOf(46);
        String featuresName = dotIndex >= 0 ? name.substring(0, dotIndex) + "." + METADATA_FILE_EXTENSION : name + "." + METADATA_FILE_EXTENSION;
        return featuresName;
    }

    public static Dictionary getForLanguage(String languageCode) {
        if (languageCode == null || "".equals(languageCode)) {
            throw new IllegalArgumentException("Language code must not be empty.");
        }
        WeakHashMap<String, Dictionary> weakHashMap = defaultDictionaries;
        synchronized (weakHashMap) {
            Dictionary dict = defaultDictionaries.get(languageCode);
            if (dict != null) {
                return dict;
            }
            try {
                String dictPath = "morfologik/dictionaries/" + languageCode + ".dict";
                String metaPath = Dictionary.getExpectedFeaturesName(dictPath);
                dict = Dictionary.readAndClose(ResourceUtils.openInputStream((String)dictPath), ResourceUtils.openInputStream((String)metaPath));
                defaultDictionaries.put(languageCode, dict);
                return dict;
            }
            catch (IOException e) {
                throw new RuntimeException("Default dictionary resource for language '" + languageCode + "not found.", e);
            }
        }
    }
}

