package com.googlecode.aviator.runtime.type.string;

import java.util.Map;

/**
 * A string segment that generated by a variable in env.
 * 
 * @author dennis(killme2008@gmail.com)
 *
 */
public class VarSegment implements StringSegment {
  private final String var;

  public VarSegment(final String var) {
    super();
    this.var = var;
  }

  @Override
  public StringBuilder appendTo(final StringBuilder sb, final Map<String, Object> env) {
    return sb.append(env.get(this.var));
  }

  @Override
  public String toString() {
    return "VarSegment [var=" + this.var + "]";
  }
}
