/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.FunctionLoader;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ClassPathConfigFunctionLoader
implements FunctionLoader {
    private static String CUSTOM_FUNCTION_LIST_FILE = System.getenv("com.googlecode.aviator.custom_function_config_file");
    private static int tatalCustomFunctions = 0;
    private Map<String, AviatorFunction> functions = this.load();

    public static ClassPathConfigFunctionLoader getInstance() {
        return StaticHolder.INSTANCE;
    }

    private ClassPathConfigFunctionLoader() {
    }

    @Override
    public AviatorFunction onFunctionNotFound(String name) {
        return this.functions.get(name);
    }

    private static void info(String msg) {
        System.out.println("[Aviator INFO] " + msg);
    }

    private static void error(String msg) {
        System.out.println("[Aviator ERROR] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AviatorFunction> load() {
        HashMap<String, AviatorFunction> ret;
        BufferedReader reader;
        InputStreamReader inreader;
        InputStream in;
        block8: {
            in = null;
            inreader = null;
            reader = null;
            ret = new HashMap<String, AviatorFunction>();
            try {
                in = ClassPathConfigFunctionLoader.class.getClassLoader().getResourceAsStream(CUSTOM_FUNCTION_LIST_FILE);
                if (in == null) break block8;
                inreader = new InputStreamReader(in);
                reader = new BufferedReader(inreader);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    AviatorFunction func;
                    if ((line = line.trim()).startsWith("#") || line.length() <= 0 || (func = this.loadClass(line)) == null) continue;
                    ret.put(func.getName(), func);
                }
            }
            catch (Throwable e) {
                try {
                    ClassPathConfigFunctionLoader.error("Load aviator custom functions config from " + CUSTOM_FUNCTION_LIST_FILE + " failed.");
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    ClassPathConfigFunctionLoader.closeQuietly(reader);
                    ClassPathConfigFunctionLoader.closeQuietly(inreader);
                    ClassPathConfigFunctionLoader.closeQuietly(in);
                    if (tatalCustomFunctions > 0) {
                        ClassPathConfigFunctionLoader.info("Total " + tatalCustomFunctions + " custom functions loaded.");
                    }
                    throw throwable;
                }
                ClassPathConfigFunctionLoader.closeQuietly(reader);
                ClassPathConfigFunctionLoader.closeQuietly(inreader);
                ClassPathConfigFunctionLoader.closeQuietly(in);
                if (tatalCustomFunctions > 0) {
                    ClassPathConfigFunctionLoader.info("Total " + tatalCustomFunctions + " custom functions loaded.");
                }
            }
        }
        ClassPathConfigFunctionLoader.closeQuietly(reader);
        ClassPathConfigFunctionLoader.closeQuietly(inreader);
        ClassPathConfigFunctionLoader.closeQuietly(in);
        if (tatalCustomFunctions > 0) {
            ClassPathConfigFunctionLoader.info("Total " + tatalCustomFunctions + " custom functions loaded.");
        }
        return ret;
    }

    private AviatorFunction loadClass(String className) {
        ClassPathConfigFunctionLoader.info("Loading custom aviator function class: '" + className + "'.");
        try {
            Class<?> clazz = Class.forName(className);
            AviatorFunction func = (AviatorFunction)clazz.newInstance();
            if (func != null) {
                ++tatalCustomFunctions;
            }
            return func;
        }
        catch (Throwable e) {
            ClassPathConfigFunctionLoader.error("Load custom aviator function class: " + className + "' failed with error:" + e.getMessage() + ".");
            return null;
        }
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static {
        if (CUSTOM_FUNCTION_LIST_FILE == null || CUSTOM_FUNCTION_LIST_FILE.trim().length() == 0) {
            CUSTOM_FUNCTION_LIST_FILE = "aviator_functions.config";
        }
    }

    private static class StaticHolder {
        private static ClassPathConfigFunctionLoader INSTANCE = new ClassPathConfigFunctionLoader();

        private StaticHolder() {
        }
    }
}

