/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.runtime.JavaMethodReflectionFunctionMissing;

public class Main {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            System.err.println("Usage: java com.googlecode.aviator.Main [file] [args]");
            System.err.println("     : java com.googlecode.aviator.Main -e [script]");
            System.err.println("     : java com.googlecode.aviator.Main -v");
            System.exit(1);
        }
        AviatorEvaluator.getInstance().setOption(Options.FEATURE_SET, Feature.getFullFeatures());
        AviatorEvaluator.getInstance().setFunctionMissing(JavaMethodReflectionFunctionMissing.getInstance());
        String cmdOrPath = args[0];
        if (cmdOrPath.equals("-v") || cmdOrPath.equals("--version")) {
            System.out.println("AviatorScript " + AviatorEvaluator.VERSION);
            System.exit(0);
        } else if (cmdOrPath.equals("-e") || cmdOrPath.equals("--execute")) {
            if (args.length < 2) {
                System.err.println("Usage: java com.googlecode.aviator.Main -e [script]");
                System.exit(1);
            }
            String script = args[1];
            String[] remainArgs = Main.getRemainArgs(args, 2);
            Expression exp = AviatorEvaluator.getInstance().compile(script);
            System.out.println(exp.execute(exp.newEnv("ARGV", remainArgs)));
        } else {
            String[] remainArgs = Main.getRemainArgs(args, 1);
            Expression exp = AviatorEvaluator.getInstance().compileScript(cmdOrPath);
            exp.execute(exp.newEnv("ARGV", remainArgs));
        }
    }

    private static String[] getRemainArgs(String[] args, int startPos) {
        String[] remainArgs = new String[args.length - startPos];
        System.arraycopy(args, startPos, remainArgs, 0, remainArgs.length);
        return remainArgs;
    }
}

