/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.exception.ExpressionSyntaxErrorException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.CharToken;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.StringToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.LinkedList;

public class ExpressionLexer {
    private static final long OVERFLOW_FLAG = 0xCCCCCCCCCCCCCCCL;
    private static final long OVERFLOW_SINGLE = 7L;
    private char peek;
    private final CharacterIterator iterator;
    private int lineNo;
    private final SymbolTable symbolTable;
    private LinkedList<Token<?>> tokenBuffer;
    private final AviatorEvaluatorInstance instance;
    private final String expression;
    private final MathContext mathContext;
    private final boolean parseFloatIntoDecimal;
    private final boolean parseIntegralNumberIntoDecimal;
    static final char[] VALID_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f'};
    static final char[] OPS = new char[]{'=', '>', '<', '+', '-', '*', '/', '%', '!', '&', '|'};

    public ExpressionLexer(AviatorEvaluatorInstance instance, String expression) {
        this.iterator = new StringCharacterIterator(expression);
        this.expression = expression;
        this.symbolTable = new SymbolTable();
        this.peek = this.iterator.current();
        this.instance = instance;
        this.lineNo = 1;
        this.mathContext = this.instance.getOptionValue((Options)Options.MATH_CONTEXT).mathContext;
        this.parseFloatIntoDecimal = this.instance.getOptionValue((Options)Options.ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL).bool;
        this.parseIntegralNumberIntoDecimal = this.instance.getOptionValue((Options)Options.ALWAYS_PARSE_INTEGRAL_NUMBER_INTO_DECIMAL).bool;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void pushback(Token<?> token) {
        if (this.tokenBuffer == null) {
            this.tokenBuffer = new LinkedList();
        }
        this.tokenBuffer.push(token);
    }

    public Token<?> scan() {
        return this.scan(true);
    }

    public void nextChar() {
        this.peek = this.iterator.next();
    }

    public void prevChar() {
        this.peek = this.iterator.previous();
    }

    public boolean isValidHexChar(char ch) {
        for (char c : VALID_HEX_CHAR) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public int getCurrentIndex() {
        return this.iterator.getIndex();
    }

    public Token<?> scan(boolean analyse) {
        if (this.tokenBuffer != null && !this.tokenBuffer.isEmpty()) {
            return this.tokenBuffer.pop();
        }
        while (true) {
            if (this.peek == '\uffff') {
                return null;
            }
            if (analyse) {
                if (this.peek != ' ' && this.peek != '\t' && this.peek != '\r' && this.peek != '\n') break;
                if (this.peek == '\n') {
                    ++this.lineNo;
                }
            } else {
                char ch = this.peek;
                int index = this.iterator.getIndex();
                this.nextChar();
                return new CharToken(ch, index);
            }
            this.nextChar();
        }
        if (Character.isDigit(this.peek) && this.peek == '0') {
            this.nextChar();
            if (this.peek == 'x' || this.peek == 'X') {
                this.nextChar();
                StringBuffer sb = new StringBuffer();
                int startIndex = this.iterator.getIndex() - 2;
                long value = 0L;
                do {
                    sb.append(this.peek);
                    value = 16L * value + (long)Character.digit(this.peek, 16);
                    this.nextChar();
                } while (this.isValidHexChar(this.peek));
                return new NumberToken(value, sb.toString(), startIndex);
            }
            this.prevChar();
        }
        if (Character.isDigit(this.peek) || this.peek == '.') {
            Number value;
            StringBuffer sb = new StringBuffer();
            int startIndex = this.iterator.getIndex();
            long lval = 0L;
            double dval = 0.0;
            boolean hasDot = false;
            double d = 10.0;
            boolean isBigInt = false;
            boolean isBigDecimal = false;
            boolean scientificNotation = false;
            boolean negExp = false;
            boolean isOverflow = false;
            do {
                sb.append(this.peek);
                if (this.peek == '.') {
                    if (scientificNotation) {
                        throw new CompileExpressionErrorException("Illegal number " + sb + " at " + this.iterator.getIndex());
                    }
                    if (hasDot) {
                        throw new CompileExpressionErrorException("Illegal Number " + sb + " at " + this.iterator.getIndex());
                    }
                    hasDot = true;
                    this.nextChar();
                    continue;
                }
                if (this.peek == 'N') {
                    if (hasDot) {
                        throw new CompileExpressionErrorException("Illegal number " + sb + " at " + this.iterator.getIndex());
                    }
                    isBigInt = true;
                    this.nextChar();
                    break;
                }
                if (this.peek == 'M') {
                    isBigDecimal = true;
                    this.nextChar();
                    break;
                }
                if (this.peek == 'e' || this.peek == 'E') {
                    if (scientificNotation) {
                        throw new CompileExpressionErrorException("Illegal number " + sb + " at " + this.iterator.getIndex());
                    }
                    scientificNotation = true;
                    this.nextChar();
                    if (this.peek != '-') continue;
                    negExp = true;
                    sb.append(this.peek);
                    this.nextChar();
                    continue;
                }
                int digit = Character.digit(this.peek, 10);
                if (scientificNotation) {
                    int n = digit;
                    this.nextChar();
                    while (Character.isDigit(this.peek)) {
                        sb.append(this.peek);
                        n = 10 * n + Character.digit(this.peek, 10);
                        this.nextChar();
                    }
                    while (n-- > 0) {
                        if (negExp) {
                            dval /= 10.0;
                            continue;
                        }
                        dval = 10.0 * dval;
                    }
                    hasDot = true;
                    continue;
                }
                if (hasDot) {
                    dval += (double)digit / d;
                    d *= 10.0;
                    this.nextChar();
                    continue;
                }
                if (!isOverflow && (lval > 0xCCCCCCCCCCCCCCCL || lval == 0xCCCCCCCCCCCCCCCL && (long)digit > 7L)) {
                    isOverflow = true;
                }
                lval = 10L * lval + (long)digit;
                dval = 10.0 * dval + (double)digit;
                this.nextChar();
            } while (Character.isDigit(this.peek) || this.peek == '.' || this.peek == 'E' || this.peek == 'e' || this.peek == 'M' || this.peek == 'N');
            if (isBigDecimal) {
                value = new BigDecimal(this.getBigNumberLexeme(sb), this.mathContext);
            } else if (isBigInt) {
                value = new BigInteger(this.getBigNumberLexeme(sb));
            } else if (hasDot) {
                if (this.parseFloatIntoDecimal && sb.length() > 1) {
                    value = new BigDecimal(sb.toString(), this.mathContext);
                } else {
                    if (sb.length() == 1) {
                        return new CharToken('.', startIndex);
                    }
                    value = dval;
                }
            } else {
                value = this.parseIntegralNumberIntoDecimal ? new BigDecimal(sb.toString(), this.mathContext) : (isOverflow ? new BigInteger(sb.toString()) : Long.valueOf(lval));
            }
            String lexeme = sb.toString();
            if (isBigDecimal || isBigInt) {
                lexeme = lexeme.substring(0, lexeme.length() - 1);
            }
            return new NumberToken(value, lexeme, startIndex);
        }
        if (this.peek == '#') {
            int startIndex = this.iterator.getIndex();
            this.nextChar();
            if (this.peek == '#') {
                while (this.peek != '\uffff' && this.peek != '\n') {
                    this.nextChar();
                }
                return this.scan(analyse);
            }
            StringBuilder sb = new StringBuilder();
            while (Character.isJavaIdentifierPart(this.peek) || this.peek == '.' || this.peek == '[' || this.peek == ']') {
                sb.append(this.peek);
                this.nextChar();
            }
            String lexeme = sb.toString();
            if (lexeme.isEmpty()) {
                throw new ExpressionSyntaxErrorException("Blank variable name after '#'");
            }
            Variable variable = new Variable(lexeme, startIndex);
            variable.setQuote(true);
            return this.symbolTable.reserve(variable);
        }
        if (Character.isJavaIdentifierStart(this.peek)) {
            int startIndex = this.iterator.getIndex();
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(this.peek);
                this.nextChar();
            } while (Character.isJavaIdentifierPart(this.peek) || this.peek == '.');
            String lexeme = sb.toString();
            Variable variable = new Variable(lexeme, startIndex);
            return this.symbolTable.reserve(variable);
        }
        if (ExpressionLexer.isBinaryOP(this.peek)) {
            CharToken opToken = new CharToken(this.peek, this.iterator.getIndex());
            this.nextChar();
            return opToken;
        }
        if (this.peek == '\"' || this.peek == '\'') {
            char left = this.peek;
            int startIndex = this.iterator.getIndex();
            StringBuilder sb = new StringBuilder();
            while ((this.peek = this.iterator.next()) != left) {
                if (this.peek == '\\') {
                    this.nextChar();
                    if (this.peek == '\uffff') {
                        throw new CompileExpressionErrorException("EOF while reading string at index: " + this.iterator.getIndex());
                    }
                    if (this.peek == left) {
                        sb.append(this.peek);
                        continue;
                    }
                    switch (this.peek) {
                        case 't': {
                            this.peek = (char)9;
                            break;
                        }
                        case 'r': {
                            this.peek = (char)13;
                            break;
                        }
                        case 'n': {
                            this.peek = (char)10;
                            break;
                        }
                        case '\\': {
                            break;
                        }
                        case 'b': {
                            this.peek = (char)8;
                            break;
                        }
                        case 'f': {
                            this.peek = (char)12;
                            break;
                        }
                        case '#': {
                            if (this.instance.isFeatureEnabled(Feature.StringInterpolation)) {
                                sb.append('\\');
                                this.peek = (char)35;
                                break;
                            }
                        }
                        default: {
                            throw new CompileExpressionErrorException("Unsupported escape character: \\" + this.peek);
                        }
                    }
                }
                if (this.peek == '\uffff') {
                    throw new CompileExpressionErrorException("EOF while reading string at index: " + this.iterator.getIndex());
                }
                sb.append(this.peek);
            }
            this.nextChar();
            return new StringToken(sb.toString(), startIndex);
        }
        CharToken token = new CharToken(this.peek, this.iterator.getIndex());
        this.nextChar();
        return token;
    }

    public String getScanString() {
        return this.expression.substring(0, this.iterator.getIndex());
    }

    private String getBigNumberLexeme(StringBuffer sb) {
        String lexeme = sb.toString();
        lexeme = lexeme.substring(0, lexeme.length() - 1);
        return lexeme;
    }

    public static boolean isBinaryOP(char ch) {
        for (char tmp : OPS) {
            if (tmp != ch) continue;
            return true;
        }
        return false;
    }
}

