/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.internal;

import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.internal.ReducerResult;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.Range;
import com.googlecode.aviator.utils.Constants;
import java.util.Map;

public class ReducerFunction
extends AbstractFunction {
    private static final long serialVersionUID = -6117602709327741955L;

    @Override
    public String getName() {
        return "__reducer_callcc";
    }

    @Override
    public final AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3) {
        Object coll = arg1.getValue(env);
        AviatorFunction iteratorFn = (AviatorFunction)((Object)arg2);
        int maxLoopCount = RuntimeUtils.getInstance(env).getOptionValue((Options)Options.MAX_LOOP_COUNT).number;
        AviatorObject result = null;
        long c = 0L;
        if (coll != Range.LOOP) {
            for (Object obj : RuntimeUtils.seq(coll, env)) {
                result = iteratorFn.call(env, AviatorRuntimeJavaType.valueOf(obj));
                if (!(result instanceof ReducerResult)) continue;
                boolean breakOut = false;
                ReducerResult midResult = (ReducerResult)result;
                result = midResult.obj;
                switch (midResult.state) {
                    case Break: {
                        breakOut = true;
                        break;
                    }
                    case Return: {
                        return midResult;
                    }
                }
                if (!breakOut) continue;
                break;
            }
        } else {
            while (true) {
                if (maxLoopCount > 0 && ++c > (long)maxLoopCount) {
                    throw new ExpressionRuntimeException("Overflow max loop count: " + maxLoopCount);
                }
                result = iteratorFn.call(env);
                if (!(result instanceof ReducerResult)) continue;
                boolean breakOut = false;
                ReducerResult midResult = (ReducerResult)result;
                result = midResult.obj;
                switch (midResult.state) {
                    case Break: {
                        breakOut = true;
                        break;
                    }
                    case Return: {
                        return midResult;
                    }
                }
                if (breakOut) break;
            }
        }
        Object contObj = arg3.getValue(env);
        if (contObj == Constants.REDUCER_EMPTY) {
            return result;
        }
        AviatorObject contResult = ((AviatorFunction)contObj).call(env);
        if (contResult == Constants.REDUCER_EMPTY) {
            return result;
        }
        return contResult;
    }
}

