/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class SeqAddFunction
extends AbstractFunction {
    private static final long serialVersionUID = -4406740199823615336L;

    @Override
    public String getName() {
        return "seq.add";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object coll = arg1.getValue(env);
        Object element = arg2.getValue(env);
        if (coll == null) {
            throw new NullPointerException("null seq");
        }
        Class<?> clazz = coll.getClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            ((Collection)coll).add(element);
            return arg1;
        }
        if (Map.class.isAssignableFrom(clazz) && element instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)element;
            ((Map)coll).put(entry.getKey(), entry.getValue());
            return arg1;
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not a collection or map.");
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3) {
        Object coll = arg1.getValue(env);
        Object key = arg2.getValue(env);
        Object value = arg3.getValue(env);
        if (coll == null) {
            throw new NullPointerException("null seq");
        }
        Class<?> clazz = coll.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            ((Map)coll).put(key, value);
            return arg1;
        }
        if (clazz.isArray()) {
            int index = ((Number)key).intValue();
            Array.set(coll, index, value);
            return arg1;
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not a map or array.");
    }
}

