/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.spring.boot.autoconfigure;

import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.persist.Watcher;
import org.casbin.spring.boot.autoconfigure.CasbinAutoConfiguration;
import org.casbin.spring.boot.autoconfigure.properties.CasbinProperties;
import org.casbin.watcher.RedisWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableConfigurationProperties(value={CasbinProperties.class, RedisProperties.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class, CasbinAutoConfiguration.class})
@ConditionalOnExpression(value="'jdbc'.equalsIgnoreCase('${casbin.storeType:jdbc}') && ${casbin.enableWatcher:false} && 'redis'.equalsIgnoreCase('${casbin.watcherType:redis}') ")
public class CasbinRedisWatcherAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CasbinRedisWatcherAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    @ConditionalOnMissingBean
    public Watcher redisWatcher(RedisProperties redisProperties, Enforcer enforcer) {
        int timeout = redisProperties.getTimeout() != null ? (int)redisProperties.getTimeout().toMillis() : 2000;
        RedisWatcher watcher = new RedisWatcher(redisProperties.getHost(), redisProperties.getPort(), redisProperties.getClientName(), timeout, redisProperties.getPassword());
        enforcer.setWatcher((Watcher)watcher);
        logger.info("Casbin set watcher: {}", (Object)watcher.getClass().getName());
        return watcher;
    }
}

