/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.spring.boot.autoconfigure;

import java.io.InputStream;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.casbin.adapter.JDBCAdapter;
import org.casbin.annotation.CasbinDataSource;
import org.casbin.exception.CasbinAdapterException;
import org.casbin.exception.CasbinModelConfigNotFoundException;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.main.SyncedEnforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.file_adapter.FileAdapter;
import org.casbin.spring.boot.autoconfigure.properties.CasbinDataSourceInitializationMode;
import org.casbin.spring.boot.autoconfigure.properties.CasbinExceptionProperties;
import org.casbin.spring.boot.autoconfigure.properties.CasbinProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={CasbinProperties.class, CasbinExceptionProperties.class, DataSourceProperties.class})
@AutoConfigureAfter(value={JdbcTemplateAutoConfiguration.class})
@ConditionalOnExpression(value="${casbin.enableCasbin:true}")
public class CasbinAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CasbinAutoConfiguration.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Bean
    @ConditionalOnProperty(name={"casbin.storeType"}, havingValue="file")
    @ConditionalOnMissingBean
    public Adapter autoConfigFileAdapter(CasbinProperties properties) {
        if (!StringUtils.hasText((String)properties.getPolicy())) throw new CasbinAdapterException("Cannot create file adapter, because policy file is not set");
        try (InputStream policyInputStream = properties.getPolicyInputStream();){
            FileAdapter fileAdapter = new FileAdapter(policyInputStream);
            return fileAdapter;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new CasbinAdapterException("Cannot create file adapter, because policy file is not set");
    }

    @Bean
    @ConditionalOnProperty(name={"casbin.storeType"}, havingValue="jdbc", matchIfMissing=true)
    @ConditionalOnBean(value={JdbcTemplate.class})
    @ConditionalOnMissingBean
    public Adapter autoConfigJdbcAdapter(@CasbinDataSource ObjectProvider<DataSource> casbinDataSource, JdbcTemplate jdbcTemplate, CasbinProperties properties, CasbinExceptionProperties exceptionProperties, DataSourceProperties dataSourceProperties) throws Exception {
        JdbcTemplate jdbcTemplateToUse = CasbinAutoConfiguration.getJdbcTemplate(jdbcTemplate, casbinDataSource);
        if (jdbcTemplateToUse == null || jdbcTemplateToUse.getDataSource() == null) {
            throw new CasbinAdapterException("Cannot create jdbc adapter, because jdbc template is not set");
        }
        String databaseName = CasbinAutoConfiguration.getDatabaseName(jdbcTemplateToUse.getDataSource());
        CasbinDataSourceInitializationMode initializeSchema = properties.getInitializeSchema();
        boolean autoCreateTable = initializeSchema == CasbinDataSourceInitializationMode.CREATE;
        String tableName = properties.getTableName();
        logger.info("Casbin current use database product: {}", (Object)databaseName);
        if (dataSourceProperties.getUrl() != null) {
            return new JDBCAdapter(dataSourceProperties.determineDriverClassName(), dataSourceProperties.getUrl(), dataSourceProperties.getUsername(), dataSourceProperties.getPassword(), exceptionProperties.isRemovePolicyFailed(), tableName, autoCreateTable);
        }
        return new JDBCAdapter(jdbcTemplateToUse.getDataSource(), exceptionProperties.isRemovePolicyFailed(), tableName, autoCreateTable);
    }

    @Bean
    @ConditionalOnMissingBean
    public Enforcer enforcer(CasbinProperties properties, Adapter adapter) {
        SyncedEnforcer enforcer;
        Model model = new Model();
        try {
            String modelContext = properties.getModelContext();
            model.loadModelFromText(modelContext);
        }
        catch (CasbinModelConfigNotFoundException e) {
            if (!properties.isUseDefaultModelIfModelNotSetting()) {
                throw e;
            }
            logger.info("Can't found model config file, use default model config");
            model.addDef("r", "r", "sub, obj, act");
            model.addDef("p", "p", "sub, obj, act");
            model.addDef("g", "g", "_, _");
            model.addDef("e", "e", "some(where (p.eft == allow))");
            model.addDef("m", "m", "g(r.sub, p.sub) && r.obj == p.obj && r.act == p.act");
        }
        if (properties.isUseSyncedEnforcer()) {
            enforcer = new SyncedEnforcer(model, adapter);
            logger.info("Casbin use SyncedEnforcer");
        } else {
            enforcer = new Enforcer(model, adapter);
        }
        enforcer.enableAutoSave(properties.isAutoSave());
        return enforcer;
    }

    private static String getDatabaseName(DataSource dataSource) {
        try {
            String productName = JdbcUtils.commonDatabaseName((String)((String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName)));
            DatabaseDriver databaseDriver = DatabaseDriver.fromProductName((String)productName);
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                throw new IllegalStateException("Unable to detect database type");
            }
            return databaseDriver.getId();
        }
        catch (MetaDataAccessException ex) {
            throw new IllegalStateException("Unable to detect database type", ex);
        }
    }

    private static JdbcTemplate getJdbcTemplate(JdbcTemplate jdbcTemplate, ObjectProvider<DataSource> dataSource) {
        DataSource dataSourceIfAvailable = (DataSource)dataSource.getIfAvailable();
        if (dataSourceIfAvailable != null) {
            logger.info("Discover the custom Casbin data source.");
            return new JdbcTemplate(dataSourceIfAvailable);
        }
        logger.info("Casbin is using the data source managed by Spring.");
        return jdbcTemplate;
    }
}

