/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.spring.boot.autoconfigure.properties;

import java.io.InputStream;
import org.casbin.exception.CasbinModelConfigNotFoundException;
import org.casbin.exception.CasbinPolicyConfigNotFoundException;
import org.casbin.spring.boot.autoconfigure.properties.CasbinDataSourceInitializationMode;
import org.casbin.spring.boot.autoconfigure.properties.CasbinStoreType;
import org.casbin.spring.boot.autoconfigure.properties.CasbinWatcherLettuceRedisType;
import org.casbin.spring.boot.autoconfigure.properties.CasbinWatcherType;
import org.casbin.utils.FileUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="casbin")
public class CasbinProperties {
    private String tableName = "casbin_rule";
    private boolean enableCasbin = true;
    private boolean useSyncedEnforcer = false;
    private String model = "classpath:casbin/model.conf";
    private String policy = "classpath:casbin/policy.csv";
    private CasbinStoreType storeType = CasbinStoreType.JDBC;
    private CasbinWatcherType watcherType = CasbinWatcherType.REDIS;
    private String policyTopic = "CASBIN_POLICY_TOPIC";
    private CasbinDataSourceInitializationMode initializeSchema = CasbinDataSourceInitializationMode.CREATE;
    private boolean enableWatcher = false;
    private boolean autoSave = true;
    private boolean useDefaultModelIfModelNotSetting = true;
    private CasbinWatcherLettuceRedisType watcherLettuceRedisType = CasbinWatcherLettuceRedisType.NONE;

    public String getModelContext() {
        String text = FileUtils.getFileAsText(this.model);
        if (text == null) {
            throw new CasbinModelConfigNotFoundException();
        }
        return text;
    }

    public InputStream getPolicyInputStream() {
        InputStream stream = FileUtils.getFileAsInputStream(this.policy);
        if (stream == null) {
            throw new CasbinPolicyConfigNotFoundException();
        }
        return stream;
    }

    public boolean isEnableCasbin() {
        return this.enableCasbin;
    }

    public void setEnableCasbin(boolean enableCasbin) {
        this.enableCasbin = enableCasbin;
    }

    public boolean isUseSyncedEnforcer() {
        return this.useSyncedEnforcer;
    }

    public void setUseSyncedEnforcer(boolean useSyncedEnforcer) {
        this.useSyncedEnforcer = useSyncedEnforcer;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public CasbinStoreType getStoreType() {
        return this.storeType;
    }

    public void setStoreType(CasbinStoreType storeType) {
        this.storeType = storeType;
    }

    public CasbinWatcherType getWatcherType() {
        return this.watcherType;
    }

    public void setWatcherType(CasbinWatcherType watcherType) {
        this.watcherType = watcherType;
    }

    public CasbinDataSourceInitializationMode getInitializeSchema() {
        return this.initializeSchema;
    }

    public void setInitializeSchema(CasbinDataSourceInitializationMode initializeSchema) {
        this.initializeSchema = initializeSchema;
    }

    public boolean isEnableWatcher() {
        return this.enableWatcher;
    }

    public void setEnableWatcher(boolean enableWatcher) {
        this.enableWatcher = enableWatcher;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isUseDefaultModelIfModelNotSetting() {
        return this.useDefaultModelIfModelNotSetting;
    }

    public void setUseDefaultModelIfModelNotSetting(boolean useDefaultModelIfModelNotSetting) {
        this.useDefaultModelIfModelNotSetting = useDefaultModelIfModelNotSetting;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPolicyTopic() {
        return this.policyTopic;
    }

    public void setPolicyTopic(String policyTopic) {
        this.policyTopic = policyTopic;
    }

    public CasbinWatcherLettuceRedisType getWatcherLettuceRedisType() {
        return this.watcherLettuceRedisType;
    }

    public void setWatcherLettuceRedisType(CasbinWatcherLettuceRedisType watcherLettuceRedisType) {
        this.watcherLettuceRedisType = watcherLettuceRedisType;
    }
}

