/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.spring.boot.autoconfigure;

import org.casbin.exception.CasbinWatcherLettuceTypeUnsupportedException;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.persist.Watcher;
import org.casbin.spring.boot.autoconfigure.CasbinAutoConfiguration;
import org.casbin.spring.boot.autoconfigure.TxWatcher;
import org.casbin.spring.boot.autoconfigure.properties.CasbinProperties;
import org.casbin.watcher.RedisWatcher;
import org.casbin.watcher.lettuce.LettuceRedisWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableConfigurationProperties(value={CasbinProperties.class, RedisProperties.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class, CasbinAutoConfiguration.class})
@ConditionalOnExpression(value="'jdbc'.equalsIgnoreCase('${casbin.store-type:jdbc}') && ${casbin.enable-watcher:false} && 'redis'.equalsIgnoreCase('${casbin.watcher-type:redis}') ")
public class CasbinRedisWatcherAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CasbinRedisWatcherAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="'redis'.equalsIgnoreCase('${casbin.watcher-type:redis}') && '${casbin.watcher-lettuce-redis-type:none}'.equalsIgnoreCase('none')")
    public Watcher redisWatcher(RedisProperties redisProperties, CasbinProperties casbinProperties, Enforcer enforcer) {
        int timeout = redisProperties.getTimeout() != null ? (int)redisProperties.getTimeout().toMillis() : 2000;
        RedisWatcher watcher = new RedisWatcher(redisProperties.getHost(), redisProperties.getPort(), casbinProperties.getPolicyTopic(), timeout, redisProperties.getPassword());
        enforcer.setWatcher((Watcher)watcher);
        logger.info("Casbin set watcher: {}", (Object)watcher.getClass().getName());
        return watcher;
    }

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="'redis'.equalsIgnoreCase('${casbin.watcher-type:redis}') && ('${casbin.watcher-lettuce-redis-type:standalone}'.equalsIgnoreCase('standalone') || '${casbin.watcher-lettuce-redis-type:cluster}'.equalsIgnoreCase('cluster'))")
    public Watcher lettuceRedisWatcher(RedisProperties redisProperties, CasbinProperties casbinProperties, Enforcer enforcer) {
        int timeout;
        int n = timeout = redisProperties.getTimeout() != null ? (int)redisProperties.getTimeout().toMillis() : 2000;
        if (casbinProperties.getWatcherLettuceRedisType().name().equalsIgnoreCase("standalone")) {
            LettuceRedisWatcher lettuceRedisWatcher = new LettuceRedisWatcher(redisProperties.getHost(), Integer.valueOf(redisProperties.getPort()), casbinProperties.getPolicyTopic(), timeout, redisProperties.getPassword());
            enforcer.setWatcher((Watcher)lettuceRedisWatcher);
            logger.info("Casbin set watcher: {}", (Object)lettuceRedisWatcher.getClass().getName());
            return lettuceRedisWatcher;
        }
        if (casbinProperties.getWatcherLettuceRedisType().name().equalsIgnoreCase("cluster")) {
            LettuceRedisWatcher lettuceRedisWatcher = new LettuceRedisWatcher(String.join((CharSequence)",", redisProperties.getCluster().getNodes()), casbinProperties.getPolicyTopic(), Integer.valueOf(timeout), redisProperties.getPassword());
            enforcer.setWatcher((Watcher)lettuceRedisWatcher);
            logger.info("Casbin set watcher: {}", (Object)lettuceRedisWatcher.getClass().getName());
            return lettuceRedisWatcher;
        }
        throw new CasbinWatcherLettuceTypeUnsupportedException("Unsupported watcher type!");
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={Watcher.class})
    @ConditionalOnProperty(value={"casbin.watcher-tx-support"}, havingValue="true")
    public Watcher txWatcher(Watcher watcher, Enforcer enforcer) {
        TxWatcher txWatcher = new TxWatcher(watcher);
        enforcer.setWatcher((Watcher)txWatcher);
        logger.info("TxWatcher proxy watcher: {}", (Object)watcher.getClass().getName());
        return txWatcher;
    }
}

