/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.spring.boot.autoconfigure;

import java.util.function.Consumer;
import org.casbin.jcasbin.persist.Watcher;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TxWatcher
implements Watcher {
    private final Watcher watcher;
    private final AfterCommitExecute afterCommitExecute;

    public TxWatcher(Watcher watcher) {
        this.watcher = watcher;
        this.afterCommitExecute = new AfterCommitExecute(watcher);
    }

    public void setUpdateCallback(Runnable runnable) {
        this.watcher.setUpdateCallback(runnable);
    }

    public void setUpdateCallback(Consumer<String> consumer) {
        this.watcher.setUpdateCallback(consumer);
    }

    public void update() {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this.afterCommitExecute);
        } else {
            this.watcher.update();
        }
    }

    public static class AfterCommitExecute
    implements TransactionSynchronization {
        private final Watcher watcher;

        public AfterCommitExecute(Watcher watcher) {
            this.watcher = watcher;
        }

        public void afterCommit() {
            this.watcher.update();
        }
    }
}

