/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.service;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.entity.CasdoorUser;
import org.casbin.casdoor.exception.CasdoorAuthException;

public class CasdoorAuthService {
    private final CasdoorConfig casdoorConfig;

    public CasdoorAuthService(CasdoorConfig casdoorConfig) {
        this.casdoorConfig = casdoorConfig;
    }

    public String getOAuthToken(String code, String state) {
        try {
            OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)String.format("%s/api/login/oauth/access_token", this.casdoorConfig.getEndpoint())).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(this.casdoorConfig.getClientId()).setClientSecret(this.casdoorConfig.getClientSecret()).setRedirectURI(String.format("%s/api/login/oauth/authorize", this.casdoorConfig.getEndpoint())).setCode(code).buildQueryMessage();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthJSONAccessTokenResponse oAuthResponse = oAuthClient.accessToken(oAuthClientRequest, "POST");
            return oAuthResponse.getAccessToken();
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            throw new CasdoorAuthException("Cannot get OAuth token.", e);
        }
    }

    public CasdoorUser parseJwtToken(String token) {
        SignedJWT parseJwt = null;
        Map claims = null;
        try {
            parseJwt = SignedJWT.parse((String)token);
            claims = parseJwt.getJWTClaimsSet().getClaims();
        }
        catch (ParseException e) {
            throw new CasdoorAuthException("Cannot parse jwt token.", e);
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.casdoorConfig.getCertificate().getBytes()));
            RSAPublicKey publicKey = (RSAPublicKey)cert.getPublicKey();
            RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
            boolean verify = parseJwt.verify((JWSVerifier)verifier);
            if (!verify) {
                throw new CasdoorAuthException("Cannot verify signature.");
            }
        }
        catch (JOSEException | CertificateException e) {
            throw new CasdoorAuthException("Cannot verify signature.", e);
        }
        try {
            CasdoorUser casdoorUser = new CasdoorUser();
            BeanUtils.copyProperties((Object)casdoorUser, (Object)claims);
            return casdoorUser;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CasdoorAuthException("Cannot convert claims to CasdoorUser", e);
        }
    }

    public String getSigninUrl(String redirectUrl) {
        String scope = "read";
        String state = this.casdoorConfig.getApplicationName();
        try {
            return String.format("%s/login/oauth/authorize?client_id=%s&response_type=code&redirect_uri=%s&scope=%s&state=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getClientId(), URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8.toString()), scope, state);
        }
        catch (UnsupportedEncodingException e) {
            throw new CasdoorAuthException(e);
        }
    }

    public String getSignupUrl() {
        return this.getSignupUrl(true, "");
    }

    public String getSignupUrl(String redirectUrl) {
        return this.getSignupUrl(false, redirectUrl);
    }

    private String getSignupUrl(boolean enablePassword, String redirectUrl) {
        if (enablePassword) {
            return String.format("%s/signup/%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getApplicationName());
        }
        return this.getSigninUrl(redirectUrl).replace("/login/oauth/authorize", "/signup/oauth/authorize");
    }

    public String getUserProfileUrl(String username, String accessToken) {
        String param = "";
        if (accessToken != null && accessToken.trim().length() != 0) {
            param = "?access_token=" + accessToken;
        }
        return String.format("%s/users/%s/%s%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getOrganizationName(), username, param);
    }

    public String getMyProfileUrl(String accessToken) {
        String param = "";
        if (accessToken != null && accessToken.trim().length() != 0) {
            param = "?access_token=" + accessToken;
        }
        return String.format("%s/account%s", this.casdoorConfig.getEndpoint(), param);
    }
}

