// Copyright 2021 The casbin Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.casbin.casdoor.entity;



import java.io.Serializable;

/**
 * Resource has the same definition as https://github.com/casbin/casdoor/blob/master/object/resource.go#L24
 * used to obtain resource-related information from Casdoor
 */

public class CasdoorResource implements Serializable {
    private String owner;
    private String name;

    public CasdoorResource(String owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "CasdoorResource{" +
                "owner='" + owner + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}


