/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.watcher.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.RedisClusterURIUtil;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.casbin.jcasbin.persist.Watcher;
import org.casbin.watcher.lettuce.LettuceSubThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LettuceRedisWatcher
implements Watcher {
    private static final Logger logger = LoggerFactory.getLogger(LettuceRedisWatcher.class);
    private final String localId;
    private final String redisChannelName;
    private final AbstractRedisClient abstractRedisClient;
    private LettuceSubThread lettuceSubThread;
    private Runnable updateCallback;

    public LettuceRedisWatcher(String redisIp, Integer redisPort, String redisChannelName, int timeout, String password) {
        this.abstractRedisClient = this.getLettuceRedisClient(redisIp, redisPort, null, password, timeout, "standalone");
        this.localId = UUID.randomUUID().toString();
        this.redisChannelName = redisChannelName;
        this.startSub();
    }

    public LettuceRedisWatcher(String redisIp, Integer redisPort, String redisChannelName) {
        this(redisIp, redisPort, redisChannelName, 2000, null);
    }

    public LettuceRedisWatcher(String nodes, String redisChannelName, Integer timeout, String password) {
        this.abstractRedisClient = this.getLettuceRedisClient(null, null, nodes, password, timeout, "cluster");
        this.localId = UUID.randomUUID().toString();
        this.redisChannelName = redisChannelName;
        this.startSub();
    }

    public void setUpdateCallback(Runnable runnable) {
        this.updateCallback = runnable;
        this.lettuceSubThread.setUpdateCallback(runnable);
    }

    public void setUpdateCallback(Consumer<String> consumer) {
        this.lettuceSubThread.setUpdateCallback(consumer);
    }

    public void update() {
        try (StatefulRedisPubSubConnection<String, String> statefulRedisPubSubConnection = this.getStatefulRedisPubSubConnection(this.abstractRedisClient);){
            if (statefulRedisPubSubConnection.isOpen()) {
                String msg = "Casbin policy has a new version from redis watcher: ".concat(this.localId);
                statefulRedisPubSubConnection.async().publish((Object)this.redisChannelName, (Object)msg);
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Publish error! The localId: " + this.localId, e);
        }
    }

    private void startSub() {
        this.lettuceSubThread = new LettuceSubThread(this.abstractRedisClient, this.redisChannelName, this.updateCallback);
        this.lettuceSubThread.start();
    }

    private AbstractRedisClient getLettuceRedisClient(String host, Integer port, String nodes, String password, int timeout, String type) {
        if (StringUtils.isNotEmpty((CharSequence)type) && StringUtils.equalsAnyIgnoreCase((CharSequence)type, (CharSequence[])new CharSequence[]{"standalone", "cluster"})) {
            DefaultClientResources clientResources = DefaultClientResources.builder().ioThreadPoolSize(4).computationThreadPoolSize(4).build();
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"standalone")) {
                RedisURI redisUri = null;
                redisUri = StringUtils.isNotEmpty((CharSequence)password) ? RedisURI.builder().withHost(host).withPort(port.intValue()).withPassword(password.toCharArray()).withTimeout(Duration.of(timeout, ChronoUnit.SECONDS)).build() : RedisURI.builder().withHost(host).withPort(port.intValue()).withTimeout(Duration.of(timeout, ChronoUnit.SECONDS)).build();
                ClientOptions clientOptions = ClientOptions.builder().autoReconnect(true).pingBeforeActivateConnection(true).build();
                RedisClient redisClient = RedisClient.create((ClientResources)clientResources, (RedisURI)redisUri);
                redisClient.setOptions(clientOptions);
                return redisClient;
            }
            TimeoutOptions timeoutOptions = TimeoutOptions.builder().fixedTimeout(Duration.of(timeout, ChronoUnit.SECONDS)).build();
            ClusterTopologyRefreshOptions topologyRefreshOptions = ClusterTopologyRefreshOptions.builder().enablePeriodicRefresh(Duration.ofMinutes(10L)).enableAdaptiveRefreshTrigger(ClusterTopologyRefreshOptions.RefreshTrigger.values()).adaptiveRefreshTriggersTimeout(Duration.ofSeconds(30L)).build();
            ClusterClientOptions clusterClientOptions = ClusterClientOptions.builder().autoReconnect(true).timeoutOptions(timeoutOptions).topologyRefreshOptions(topologyRefreshOptions).pingBeforeActivateConnection(true).validateClusterNodeMembership(true).build();
            String redisUri = StringUtils.isNotEmpty((CharSequence)password) ? "redis://".concat(password).concat("@").concat(nodes) : "redis://".concat(nodes);
            logger.info("Redis Cluster Uri: {}", (Object)redisUri);
            List redisURIList = RedisClusterURIUtil.toRedisURIs((URI)URI.create(redisUri));
            RedisClusterClient redisClusterClient = RedisClusterClient.create((ClientResources)clientResources, (RedisURI)((RedisURI)redisURIList.get(0)));
            redisClusterClient.setOptions(clusterClientOptions);
            return redisClusterClient;
        }
        throw new IllegalArgumentException("Redis-Type is required and can only be [standalone] or [cluster]");
    }

    private StatefulRedisPubSubConnection<String, String> getStatefulRedisPubSubConnection(AbstractRedisClient abstractRedisClient) {
        if (abstractRedisClient instanceof RedisClient) {
            return ((RedisClient)abstractRedisClient).connectPubSub();
        }
        return ((RedisClusterClient)abstractRedisClient).connectPubSub();
    }
}

