/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.watcher;

import java.util.function.Consumer;
import org.casbin.watcher.Subscriber;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class SubThread
extends Thread {
    private final JedisPool jedisPool;
    private final Subscriber subscriber;
    private final String channel;

    public SubThread(JedisPool jedisPool, String channel, Runnable updateCallback) {
        super("SubThread");
        this.jedisPool = jedisPool;
        this.channel = channel;
        this.subscriber = new Subscriber(updateCallback);
    }

    public void setUpdateCallback(Runnable runnable) {
        this.subscriber.setUpdateCallback(runnable);
    }

    public void setUpdateCallback(Consumer<String> consumer) {
        this.subscriber.setUpdateCallback(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Jedis jedis = this.jedisPool.getResource();
                Throwable throwable = null;
                try {
                    jedis.subscribe((JedisPubSub)this.subscriber, new String[]{this.channel});
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jedis == null) continue;
                    if (throwable != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jedis.close();
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }
}

