/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.casbin.jcasbin.effect.DefaultEffector;
import org.casbin.jcasbin.effect.Effect;
import org.casbin.jcasbin.effect.Effector;
import org.casbin.jcasbin.effect.StreamEffector;
import org.casbin.jcasbin.exception.CasbinAdapterException;
import org.casbin.jcasbin.exception.CasbinEffectorException;
import org.casbin.jcasbin.exception.CasbinMatcherException;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.FunctionMap;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Dispatcher;
import org.casbin.jcasbin.persist.FilteredAdapter;
import org.casbin.jcasbin.persist.Watcher;
import org.casbin.jcasbin.persist.WatcherEx;
import org.casbin.jcasbin.rbac.DefaultRoleManager;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.BuiltInFunctions;
import org.casbin.jcasbin.util.EnforceContext;
import org.casbin.jcasbin.util.Util;

public class CoreEnforcer {
    String modelPath;
    Model model;
    FunctionMap fm;
    private Effector eft;
    Adapter adapter;
    Watcher watcher;
    Dispatcher dispatcher;
    Map<String, RoleManager> rmMap;
    private boolean enabled;
    boolean autoSave;
    boolean autoBuildRoleLinks;
    boolean autoNotifyWatcher = true;
    boolean autoNotifyDispatcher = true;
    private AviatorEvaluatorInstance aviatorEval;

    void initialize() {
        this.rmMap = new HashMap<String, RoleManager>();
        this.eft = new DefaultEffector();
        this.watcher = null;
        this.enabled = true;
        this.autoSave = true;
        this.autoBuildRoleLinks = true;
        this.dispatcher = null;
        this.aviatorEval = AviatorEvaluator.newInstance();
        this.initRmMap();
        this.initBuiltInFunction();
    }

    public static Model newModel() {
        Model m = new Model();
        return m;
    }

    public static Model newModel(String text) {
        Model m = new Model();
        m.loadModelFromText(text);
        return m;
    }

    public static Model newModel(String modelPath, String unused) {
        Model m = new Model();
        if (!modelPath.equals("")) {
            m.loadModel(modelPath);
        }
        return m;
    }

    public void loadModel() {
        this.model = CoreEnforcer.newModel();
        this.model.loadModel(this.modelPath);
        this.model.printModel();
        this.fm = FunctionMap.loadFunctionMap();
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
        this.fm = FunctionMap.loadFunctionMap();
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
        watcher.setUpdateCallback(this::loadPolicy);
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Map<String, RoleManager> getRmMap() {
        return this.rmMap;
    }

    public void setRoleManager(RoleManager rm) {
        this.setRoleManager("g", rm);
    }

    public void setEffector(Effector eft) {
        this.eft = eft;
    }

    public void clearPolicy() {
        this.model.clearPolicy();
    }

    public void loadPolicy() {
        this.model.clearPolicy();
        this.adapter.loadPolicy(this.model);
        this.model.sortPoliciesByPriority();
        this.clearRmMap();
        this.model.printPolicy();
        if (this.autoBuildRoleLinks) {
            this.buildRoleLinks();
        }
    }

    public void loadFilteredPolicy(Object filter) {
        this.model.clearPolicy();
        if (!(this.adapter instanceof FilteredAdapter)) {
            throw new CasbinAdapterException("Filtered policies are not supported by this adapter.");
        }
        FilteredAdapter filteredAdapter = (FilteredAdapter)this.adapter;
        try {
            filteredAdapter.loadFilteredPolicy(this.model, filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.model.sortPoliciesByPriority();
        this.initRmMap();
        this.model.printPolicy();
        if (this.autoBuildRoleLinks) {
            this.buildRoleLinks();
        }
    }

    public boolean isFiltered() {
        if (this.adapter instanceof FilteredAdapter) {
            return ((FilteredAdapter)this.adapter).isFiltered();
        }
        return false;
    }

    public void savePolicy() {
        if (this.isFiltered()) {
            throw new IllegalArgumentException("cannot save a filtered policy");
        }
        this.adapter.savePolicy(this.model);
        if (this.watcher != null && this.autoNotifyWatcher) {
            if (this.watcher instanceof WatcherEx) {
                ((WatcherEx)this.watcher).updateForSavePolicy(this.model);
            } else {
                this.watcher.update();
            }
        }
    }

    public void setRoleManager(String ptype, RoleManager rm) {
        this.rmMap.put(ptype, rm);
    }

    private void initRmMap() {
        if (!this.model.model.containsKey("g")) {
            return;
        }
        for (String ptype : ((Map)this.model.model.get("g")).keySet()) {
            if (this.rmMap.containsKey(ptype)) {
                this.rmMap.get(ptype).clear();
                continue;
            }
            this.rmMap.put(ptype, new DefaultRoleManager(10));
        }
    }

    private void initBuiltInFunction() {
        for (Map.Entry<String, AviatorFunction> entry : this.fm.fm.entrySet()) {
            AviatorFunction function = entry.getValue();
            if (this.aviatorEval.containsFunction(function.getName())) {
                this.aviatorEval.removeFunction(function.getName());
            }
            this.aviatorEval.addFunction(function);
        }
    }

    private void clearRmMap() {
        if (!this.model.model.containsKey("g")) {
            return;
        }
        for (String ptype : ((Map)this.model.model.get("g")).keySet()) {
            this.rmMap.get(ptype).clear();
        }
    }

    public void enableEnforce(boolean enable) {
        this.enabled = enable;
    }

    public void enableLog(boolean enable) {
        Util.enableLog = enable;
    }

    public void enableAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public void enableAutoBuildRoleLinks(boolean autoBuildRoleLinks) {
        this.autoBuildRoleLinks = autoBuildRoleLinks;
    }

    public void buildRoleLinks() {
        for (RoleManager rm : this.rmMap.values()) {
            rm.clear();
        }
        this.model.buildRoleLinks(this.rmMap);
    }

    /*
     * WARNING - void declaration
     */
    private boolean enforce(String matcher, Object ... rvals) {
        float[] matcherResults;
        Effect[] policyEffects;
        void var6_11;
        StreamEffector streamEffector;
        Expression expression;
        String eType;
        String rType;
        block30: {
            if (!this.enabled) {
                return true;
            }
            boolean compileCached = true;
            if (this.fm.isModify) {
                compileCached = false;
                this.initBuiltInFunction();
                this.fm.isModify = false;
            }
            HashMap<String, AviatorFunction> gFunctions = new HashMap<String, AviatorFunction>();
            if (this.model.model.containsKey("g")) {
                for (Map.Entry entry : ((Map)this.model.model.get("g")).entrySet()) {
                    String key = (String)entry.getKey();
                    Assertion ast = (Assertion)entry.getValue();
                    RoleManager rm = ast.rm;
                    AviatorFunction aviatorFunction = BuiltInFunctions.GenerateGFunctionClass.generateGFunction(key, rm);
                    gFunctions.put(key, aviatorFunction);
                }
            }
            for (AviatorFunction aviatorFunction : gFunctions.values()) {
                if (this.aviatorEval.containsFunction(aviatorFunction.getName())) continue;
                this.aviatorEval.addFunction(aviatorFunction);
                compileCached = false;
            }
            this.fm.setAviatorEval(this.aviatorEval);
            rType = "r";
            String string = "p";
            eType = "e";
            String mType = "m";
            if (rvals.length != 0 && rvals[0] instanceof EnforceContext) {
                EnforceContext enforceContext = (EnforceContext)rvals[0];
                rType = enforceContext.getrType();
                String string2 = enforceContext.getpType();
                eType = enforceContext.geteType();
                mType = enforceContext.getmType();
                rvals = Arrays.copyOfRange(rvals, 1, rvals.length);
            }
            String expString = matcher == null || "".equals(matcher) ? ((Assertion)((Map)this.model.model.get((Object)"m")).get((Object)mType)).value : Util.removeComments(Util.escapeAssertion(matcher));
            expString = Util.convertInSyntax(expString);
            expression = this.aviatorEval.compile(Util.md5(expString), expString, compileCached);
            streamEffector = null;
            try {
                streamEffector = this.eft.newStreamEffector(((Assertion)((Map)this.model.model.get((Object)"e")).get((Object)eType)).value);
            }
            catch (Exception e) {
                if (e instanceof UnsupportedOperationException) break block30;
                throw new CasbinEffectorException(e);
            }
        }
        int policyLen = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)var6_11)).policy.size();
        if (policyLen != 0) {
            policyEffects = new Effect[policyLen];
            matcherResults = new float[policyLen];
            for (int i = 0; i < ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)var6_11)).policy.size(); ++i) {
                boolean done;
                List<String> pvals = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)var6_11)).policy.get(i);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                this.getRTokens(parameters, rvals);
                for (int j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)var6_11)).tokens.length; ++j) {
                    String token = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)var6_11)).tokens[j];
                    parameters.put(token, pvals.get(j));
                }
                Object result = expression.execute(parameters);
                if (result instanceof Boolean) {
                    policyEffects[i] = (Boolean)result == false ? Effect.Indeterminate : Effect.Allow;
                    if (streamEffector == null) {
                        continue;
                    }
                } else if (result instanceof Float) {
                    if (((Float)result).floatValue() == 0.0f) {
                        policyEffects[i] = Effect.Indeterminate;
                    } else {
                        matcherResults[i] = ((Float)result).floatValue();
                        policyEffects[i] = Effect.Allow;
                    }
                    if (streamEffector == null) {
                        continue;
                    }
                } else {
                    throw new CasbinMatcherException("matcher result should be bool, int or float");
                }
                if (policyEffects[i] == Effect.Allow && parameters.containsKey((String)var6_11 + "_eft")) {
                    String eft = (String)parameters.get((String)var6_11 + "_eft");
                    policyEffects[i] = "allow".equals(eft) ? Effect.Allow : ("deny".equals(eft) ? Effect.Deny : Effect.Indeterminate);
                }
                if (!(streamEffector != null ? (done = streamEffector.push(policyEffects[i], i, policyLen)) : "priority(p_eft) || deny".equals(((Assertion)((Map)this.model.model.get((Object)"e")).get((Object)eType)).value))) {
                    continue;
                }
                break;
            }
        } else {
            String token;
            int j;
            policyEffects = new Effect[1];
            matcherResults = new float[1];
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)rType)).tokens.length; ++j) {
                token = ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)rType)).tokens[j];
                parameters.put(token, rvals[j]);
            }
            for (j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)var6_11)).tokens.length; ++j) {
                token = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)var6_11)).tokens[j];
                parameters.put(token, "");
            }
            Object result = expression.execute(parameters);
            if (streamEffector != null) {
                if (((Boolean)result).booleanValue()) {
                    streamEffector.push(Effect.Allow, 0, 1);
                } else {
                    streamEffector.push(Effect.Indeterminate, 0, 1);
                }
            } else {
                policyEffects[0] = (Boolean)result != false ? Effect.Allow : Effect.Indeterminate;
            }
        }
        boolean result = streamEffector != null && streamEffector.current() != null ? streamEffector.current().hasEffect() : this.eft.mergeEffects(((Assertion)((Map)this.model.model.get((Object)"e")).get((Object)eType)).value, policyEffects, matcherResults);
        StringBuilder reqStr = new StringBuilder("Request: ");
        for (int i = 0; i < rvals.length; ++i) {
            String rval = rvals[i].toString();
            if (i != rvals.length - 1) {
                reqStr.append(String.format("%s, ", rval));
                continue;
            }
            reqStr.append(String.format("%s", rval));
        }
        reqStr.append(String.format(" ---> %s", result));
        Util.logPrint(reqStr.toString());
        return result;
    }

    public boolean enforce(Object ... rvals) {
        return this.enforce(null, rvals);
    }

    public boolean enforceWithMatcher(String matcher, Object ... rvals) {
        return this.enforce(matcher, rvals);
    }

    public boolean addNamedMatchingFunc(String ptype, String name, BiPredicate<String, String> fn) {
        if (this.rmMap.containsKey(ptype)) {
            DefaultRoleManager rm = (DefaultRoleManager)this.rmMap.get(ptype);
            rm.addMatchingFunc(name, fn);
            this.clearRmMap();
            if (this.autoBuildRoleLinks) {
                this.buildRoleLinks();
            }
            return true;
        }
        return false;
    }

    public boolean addNamedDomainMatchingFunc(String ptype, String name, BiPredicate<String, String> fn) {
        if (this.rmMap.containsKey(ptype)) {
            DefaultRoleManager rm = (DefaultRoleManager)this.rmMap.get(ptype);
            rm.addDomainMatchingFunc(name, fn);
            this.clearRmMap();
            if (this.autoBuildRoleLinks) {
                this.buildRoleLinks();
            }
            return true;
        }
        return false;
    }

    private void getRTokens(Map<String, Object> parameters, Object ... rvals) {
        for (String rKey : ((Map)this.model.model.get("r")).keySet()) {
            if (rvals.length != ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)rKey)).tokens.length) continue;
            for (int j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)rKey)).tokens.length; ++j) {
                String token = ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)rKey)).tokens[j];
                parameters.put(token, rvals[j]);
            }
        }
    }

    public boolean validateEnforce(Object ... rvals) {
        return this.validateEnforceSection("r", rvals);
    }

    private boolean validateEnforceSection(String section, Object ... rvals) {
        int expectedParamSize = ((Assertion)this.getModel().model.entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$validateEnforceSection$0(java.lang.String java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((String)section)).flatMap((Function<Map.Entry, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$validateEnforceSection$1(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/util/stream/Stream;)()).filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$validateEnforceSection$2(java.lang.String java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((String)section)).findFirst().orElseThrow((Supplier<CasbinMatcherException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$validateEnforceSection$3(java.lang.String ), ()Lorg/casbin/jcasbin/exception/CasbinMatcherException;)((String)section)).getValue()).tokens.length;
        if (rvals.length != expectedParamSize) {
            Util.logPrintfWarn("Incorrect number of attributes to check for policy (expected {} but got {})", expectedParamSize, rvals.length);
            return rvals.length >= expectedParamSize;
        }
        return true;
    }

    public void resetExpressionEvaluator() {
        this.fm.setAviatorEval(null);
    }

    public boolean isAutoNotifyWatcher() {
        return this.autoNotifyWatcher;
    }

    public void setAutoNotifyWatcher(boolean autoNotifyWatcher) {
        this.autoNotifyWatcher = autoNotifyWatcher;
    }

    public boolean isAutoNotifyDispatcher() {
        return this.autoNotifyDispatcher;
    }

    public void setAutoNotifyDispatcher(boolean autoNotifyDispatcher) {
        this.autoNotifyDispatcher = autoNotifyDispatcher;
    }

    protected boolean mustUseDispatcher() {
        return this.dispatcher != null && this.autoNotifyDispatcher;
    }

    private static /* synthetic */ CasbinMatcherException lambda$validateEnforceSection$3(String section) {
        return new CasbinMatcherException("Could not find " + section + " definition in model");
    }

    private static /* synthetic */ boolean lambda$validateEnforceSection$2(String section, Map.Entry stringAssertionEntry) {
        return ((String)stringAssertionEntry.getKey()).equals(section);
    }

    private static /* synthetic */ Stream lambda$validateEnforceSection$1(Map.Entry stringMapEntry) {
        return ((Map)stringMapEntry.getValue()).entrySet().stream();
    }

    private static /* synthetic */ boolean lambda$validateEnforceSection$0(String section, Map.Entry stringMapEntry) {
        return ((String)stringMapEntry.getKey()).equals(section);
    }
}

