/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.casbin.jcasbin.main.SyncedEnforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.cache.Cache;
import org.casbin.jcasbin.persist.cache.CacheableParam;
import org.casbin.jcasbin.persist.cache.DefaultCache;

public class SyncedCachedEnforcer
extends SyncedEnforcer {
    private Duration expireTime;
    private Cache cache;
    private final AtomicBoolean enableCache = new AtomicBoolean(true);
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();

    public SyncedCachedEnforcer() {
        this.cache = new DefaultCache();
    }

    public SyncedCachedEnforcer(String modelPath, String policyFile) {
        super(modelPath, policyFile);
        this.cache = new DefaultCache();
    }

    public SyncedCachedEnforcer(String modelPath, Adapter adapter) {
        super(modelPath, adapter);
        this.cache = new DefaultCache();
    }

    public SyncedCachedEnforcer(Model m, Adapter adapter) {
        super(m, adapter);
        this.cache = new DefaultCache();
    }

    public SyncedCachedEnforcer(Model m) {
        super(m);
        this.cache = new DefaultCache();
    }

    public SyncedCachedEnforcer(String modelPath) {
        super(modelPath);
        this.cache = new DefaultCache();
    }

    public SyncedCachedEnforcer(String modelPath, String policyFile, boolean enableLog) {
        super(modelPath, policyFile, enableLog);
        this.cache = new DefaultCache();
    }

    public void enableCache(boolean enable) {
        this.enableCache.set(enable);
    }

    @Override
    public boolean enforce(Object ... rvals) {
        if (this.enableCache.get()) {
            return super.enforce(rvals);
        }
        String key = this.getKey(rvals);
        if (key == null) {
            return super.enforce(rvals);
        }
        Boolean cachedResult = this.getCachedResult(key);
        if (cachedResult.booleanValue()) {
            return cachedResult;
        }
        boolean result = super.enforce(rvals);
        this.setCachedResult(key, result, this.expireTime);
        return result;
    }

    @Override
    public void loadPolicy() {
        if (this.enableCache == null || !this.enableCache.get()) {
            super.loadPolicy();
        } else {
            if (this.enableCache.get()) {
                this.cache.clear();
            }
            super.loadPolicy();
        }
    }

    @Override
    public boolean addPolicy(String ... params) {
        if (!this.checkOneAndRemoveCache(params)) {
            return false;
        }
        return super.addPolicy(params);
    }

    @Override
    public boolean addPolicies(List<List<String>> rules) {
        if (!this.checkManyAndRemoveCache(rules)) {
            return false;
        }
        return super.addPolicies(rules);
    }

    @Override
    public boolean removePolicy(String ... params) {
        if (!this.checkOneAndRemoveCache(params)) {
            return false;
        }
        return super.removePolicy(params);
    }

    @Override
    public boolean removePolicies(List<List<String>> rules) {
        if (!this.checkManyAndRemoveCache(rules)) {
            return false;
        }
        return super.removePolicies(rules);
    }

    private Boolean getCachedResult(String key) {
        try {
            READ_WRITE_LOCK.readLock().lock();
            Boolean bl = this.cache.get(key);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    public void setExpireTime(Duration expireTime) {
        READ_WRITE_LOCK.writeLock().lock();
        try {
            this.expireTime = expireTime;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    public void setCache(Cache cache) {
        READ_WRITE_LOCK.writeLock().lock();
        try {
            this.cache = cache;
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    private void setCachedResult(String key, boolean result, Object ... extra) {
        this.cache.set(key, result, extra);
    }

    public String getCacheKey(Object ... params) {
        StringBuilder key = new StringBuilder();
        for (Object param : params) {
            if (param instanceof String) {
                key.append((String)param);
            } else if (param instanceof CacheableParam) {
                key.append(((CacheableParam)param).getCacheKey());
            } else {
                return "";
            }
            key.append("$$");
        }
        return key.toString();
    }

    private String getKey(Object ... params) {
        return this.getCacheKey(params);
    }

    public void invalidateCache() {
        this.cache.clear();
    }

    private boolean checkOneAndRemoveCache(String ... params) {
        String key;
        if (this.enableCache.get() && (key = this.getKey(new Object[]{params})) != null) {
            this.cache.delete(key);
        }
        return true;
    }

    private boolean checkManyAndRemoveCache(List<List<String>> rules) {
        if (!rules.isEmpty() && this.enableCache.get()) {
            for (List<String> rule : rules) {
                String key = this.getKey(rule);
                if (key == null) continue;
                this.cache.delete(key);
            }
        }
        return true;
    }
}

