/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.adapter;

import dev.failsafe.ExecutionContext;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.casbin.adapter.CasbinRule;
import org.casbin.adapter.JDBCDataSource;
import org.casbin.jcasbin.exception.CasbinAdapterException;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.BatchAdapter;
import org.casbin.jcasbin.persist.Helper;
import org.casbin.jcasbin.persist.UpdatableAdapter;

abstract class JDBCBaseAdapter
implements Adapter,
BatchAdapter,
UpdatableAdapter {
    protected static final String DEFAULT_TABLE_NAME = "casbin_rule";
    protected static final boolean DEFAULT_REMOVE_POLICY_FAILED = false;
    protected static final boolean DEFAULT_AUTO_CREATE_TABLE = true;
    protected static final int _DEFAULT_CONNECTION_TRIES = 3;
    protected DataSource dataSource;
    protected String tableName;
    protected boolean removePolicyFailed;
    private final int batchSize = 1000;
    protected Connection conn;
    protected RetryPolicy<Object> retryPolicy;

    protected JDBCBaseAdapter(String driver, String url, String username, String password) throws Exception {
        this(new JDBCDataSource(driver, url, username, password));
    }

    protected JDBCBaseAdapter(String driver, String url, String username, String password, boolean removePolicyFailed, String tableName, boolean autoCreateTable) throws Exception {
        this(new JDBCDataSource(driver, url, username, password), removePolicyFailed, tableName, autoCreateTable);
    }

    protected JDBCBaseAdapter(DataSource dataSource) throws Exception {
        this(dataSource, false, DEFAULT_TABLE_NAME, true);
    }

    protected JDBCBaseAdapter(DataSource dataSource, boolean removePolicyFailed, String tableName, boolean autoCreateTable) throws Exception {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.removePolicyFailed = removePolicyFailed;
        this.retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle(SQLException.class)).withDelay(Duration.ofSeconds(1L)).withMaxRetries(3).build();
        this.conn = dataSource.getConnection();
        if (autoCreateTable) {
            this.migrate();
        }
    }

    protected void migrate() throws SQLException {
        String productName;
        Statement stmt = this.conn.createStatement();
        String sql = this.renderActualSql("CREATE TABLE IF NOT EXISTS casbin_rule(id int NOT NULL PRIMARY KEY auto_increment, ptype VARCHAR(100) NOT NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))");
        switch (productName = this.conn.getMetaData().getDatabaseProductName()) {
            case "MySQL": {
                String hasTableSql = this.renderActualSql("SHOW TABLES LIKE 'casbin_rule';");
                ResultSet rs = stmt.executeQuery(hasTableSql);
                if (!rs.next()) break;
                return;
            }
            case "Oracle": {
                sql = this.renderActualSql("declare begin execute immediate 'CREATE TABLE CASBIN_RULE(id NUMBER(5, 0) not NULL primary key, ptype VARCHAR(100) not NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))'; exception when others then if SQLCODE = -955 then null; else raise; end if; end;");
                break;
            }
            case "Microsoft SQL Server": {
                sql = this.renderActualSql("IF NOT EXISTS (SELECT * FROM sysobjects WHERE name='casbin_rule' and xtype='U') CREATE TABLE casbin_rule(id int NOT NULL primary key identity(1, 1), ptype VARCHAR(100) NOT NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))");
                break;
            }
            case "PostgreSQL": {
                sql = this.renderActualSql("do $$ BEGIN IF (select count(*) from information_schema.tables where table_name = 'casbin_rule') = 0 THEN CREATE SEQUENCE IF NOT EXISTS CASBIN_SEQUENCE START 1; END IF; END; $$;");
                break;
            }
            case "H2": {
                sql = this.renderActualSql("CREATE TABLE IF NOT EXISTS casbin_rule(id int GENERATED ALWAYS AS IDENTITY PRIMARY KEY, ptype VARCHAR(100) NOT NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))");
            }
        }
        stmt.executeUpdate(sql);
        if ("Oracle".equals(productName)) {
            sql = this.renderActualSql("declare V_NUM number;BEGIN V_NUM := 0;  select count(0) into V_NUM from user_sequences where sequence_name = 'CASBIN_SEQUENCE';if V_NUM > 0 then null;else execute immediate 'CREATE SEQUENCE casbin_sequence increment by 1 start with 1 nomaxvalue nocycle nocache';end if;END;");
            stmt.executeUpdate(sql);
            sql = this.renderActualSql("declare V_NUM number;BEGIN V_NUM := 0;select count(0) into V_NUM from user_triggers where trigger_name = 'CASBIN_ID_AUTOINCREMENT';if V_NUM > 0 then null;else execute immediate 'create trigger casbin_id_autoincrement before                         insert on CASBIN_RULE for each row                         when (new.id is null)                         begin                         select casbin_sequence.nextval into:new.id from dual;                        end;';end if;END;");
            stmt.executeUpdate(sql);
        } else if ("PostgreSQL".equals(productName)) {
            sql = this.renderActualSql("CREATE TABLE IF NOT EXISTS casbin_rule(id int NOT NULL PRIMARY KEY default nextval('CASBIN_SEQUENCE'::regclass), ptype VARCHAR(100) NOT NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))");
            stmt.executeUpdate(sql);
        }
    }

    protected void loadPolicyLine(CasbinRule line, Model model) {
        String lineText = line.ptype;
        if (!"".equals(line.v0)) {
            lineText = lineText + ", " + line.v0;
        }
        if (!"".equals(line.v1)) {
            lineText = lineText + ", " + line.v1;
        }
        if (!"".equals(line.v2)) {
            lineText = lineText + ", " + line.v2;
        }
        if (!"".equals(line.v3)) {
            lineText = lineText + ", " + line.v3;
        }
        if (!"".equals(line.v4)) {
            lineText = lineText + ", " + line.v4;
        }
        if (!"".equals(line.v5)) {
            lineText = lineText + ", " + line.v5;
        }
        Helper.loadPolicyLine((String)lineText, (Model)model);
    }

    public void loadPolicy(Model model) {
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            try (Statement stmt = this.conn.createStatement();
                 ResultSet rSet = stmt.executeQuery(this.renderActualSql("SELECT ptype,v0,v1,v2,v3,v4,v5 FROM casbin_rule"));){
                ResultSetMetaData rData = rSet.getMetaData();
                while (rSet.next()) {
                    CasbinRule line = new CasbinRule();
                    line.ptype = rSet.getObject(1) == null ? "" : (String)rSet.getObject(1);
                    line.v0 = rSet.getObject(2) == null ? "" : (String)rSet.getObject(2);
                    line.v1 = rSet.getObject(3) == null ? "" : (String)rSet.getObject(3);
                    line.v2 = rSet.getObject(4) == null ? "" : (String)rSet.getObject(4);
                    line.v3 = rSet.getObject(5) == null ? "" : (String)rSet.getObject(5);
                    line.v4 = rSet.getObject(6) == null ? "" : (String)rSet.getObject(6);
                    line.v5 = rSet.getObject(7) == null ? "" : (String)rSet.getObject(7);
                    this.loadPolicyLine(line, model);
                }
            }
        });
    }

    private CasbinRule savePolicyLine(String ptype, List<String> rule) {
        CasbinRule line = new CasbinRule();
        line.ptype = ptype;
        if (rule.size() > 0) {
            line.v0 = rule.get(0);
        }
        if (rule.size() > 1) {
            line.v1 = rule.get(1);
        }
        if (rule.size() > 2) {
            line.v2 = rule.get(2);
        }
        if (rule.size() > 3) {
            line.v3 = rule.get(3);
        }
        if (rule.size() > 4) {
            line.v4 = rule.get(4);
        }
        if (rule.size() > 5) {
            line.v5 = rule.get(5);
        }
        return line;
    }

    public void savePolicy(Model model) {
        String cleanSql = this.renderActualSql("delete from casbin_rule");
        String addSql = this.renderActualSql("INSERT INTO casbin_rule (ptype,v0,v1,v2,v3,v4,v5) VALUES(?,?,?,?,?,?,?)");
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            this.conn.setAutoCommit(false);
            int count = 0;
            try (Statement statement = this.conn.createStatement();
                 PreparedStatement ps = this.conn.prepareStatement(addSql);){
                statement.execute(cleanSql);
                count = this.saveSectionPolicyWithBatch(model, "p", ps, count);
                count = this.saveSectionPolicyWithBatch(model, "g", ps, count);
                if (count != 0) {
                    ps.executeBatch();
                }
                this.conn.commit();
            }
            catch (SQLException e) {
                this.conn.rollback();
                e.printStackTrace();
                throw e;
            }
            finally {
                this.conn.setAutoCommit(true);
            }
        });
    }

    private int saveSectionPolicyWithBatch(Model model, String section, PreparedStatement ps, int batchCount) throws SQLException {
        if (!model.model.containsKey(section)) {
            return batchCount;
        }
        for (Map.Entry entry : ((Map)model.model.get(section)).entrySet()) {
            String ptype = (String)entry.getKey();
            Assertion ast = (Assertion)entry.getValue();
            for (List rule : ast.policy) {
                CasbinRule line = this.savePolicyLine(ptype, rule);
                ps.setString(1, line.ptype);
                ps.setString(2, line.v0);
                ps.setString(3, line.v1);
                ps.setString(4, line.v2);
                ps.setString(5, line.v3);
                ps.setString(6, line.v4);
                ps.setString(7, line.v5);
                ps.addBatch();
                if (++batchCount != 1000) continue;
                batchCount = 0;
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        return batchCount;
    }

    public void addPolicy(String sec, String ptype, List<String> rule) {
        ArrayList<List<String>> rules = new ArrayList<List<String>>();
        rules.add(rule);
        this.addPolicies(sec, ptype, rules);
    }

    public void addPolicies(String sec, String ptype, List<List<String>> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        String sql = this.renderActualSql("INSERT INTO casbin_rule (ptype,v0,v1,v2,v3,v4,v5) VALUES(?,?,?,?,?,?,?)");
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            this.conn.setAutoCommit(false);
            int count = 0;
            try (PreparedStatement ps = this.conn.prepareStatement(sql);){
                for (List rule : rules) {
                    CasbinRule line = this.savePolicyLine(ptype, rule);
                    ps.setString(1, line.ptype);
                    ps.setString(2, line.v0);
                    ps.setString(3, line.v1);
                    ps.setString(4, line.v2);
                    ps.setString(5, line.v3);
                    ps.setString(6, line.v4);
                    ps.setString(7, line.v5);
                    ps.addBatch();
                    if (++count != 1000) continue;
                    count = 0;
                    ps.executeBatch();
                    ps.clearBatch();
                }
                if (count != 0) {
                    ps.executeBatch();
                }
                this.conn.commit();
            }
            catch (SQLException e) {
                this.conn.rollback();
                e.printStackTrace();
                throw e;
            }
            finally {
                this.conn.setAutoCommit(true);
            }
        });
    }

    public void removePolicy(String sec, String ptype, List<String> rule) {
        if (CollectionUtils.isEmpty(rule)) {
            return;
        }
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            String sql = this.renderActualSql("DELETE FROM casbin_rule WHERE ptype = ?");
            int columnIndex = 0;
            for (int i = 0; i < rule.size(); ++i) {
                sql = String.format("%s%s%s%s", sql, " AND v", columnIndex, " = ?");
                ++columnIndex;
            }
            while (columnIndex <= 5) {
                sql = String.format("%s%s%s%s", sql, " AND v", columnIndex, " IS NULL");
                ++columnIndex;
            }
            try (PreparedStatement ps = this.conn.prepareStatement(sql);){
                ps.setString(1, ptype);
                for (int j = 0; j < rule.size(); ++j) {
                    ps.setString(j + 2, (String)rule.get(j));
                }
                int rows = ps.executeUpdate();
                if (rows < 1 && this.removePolicyFailed) {
                    throw new CasbinAdapterException(String.format("Remove policy error, remove %d rows, expect least 1 rows", rows));
                }
            }
        });
    }

    public void removePolicies(String sec, String ptype, List<List<String>> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            this.conn.setAutoCommit(false);
            try {
                for (List rule : rules) {
                    this.removePolicy(sec, ptype, rule);
                }
                this.conn.commit();
            }
            catch (SQLException e) {
                this.conn.rollback();
                e.printStackTrace();
                throw e;
            }
            finally {
                this.conn.setAutoCommit(true);
            }
        });
    }

    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        List values = Optional.of(Arrays.asList(fieldValues)).orElse(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)values)) {
            return;
        }
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            String sql = this.renderActualSql("DELETE FROM casbin_rule WHERE ptype = ?");
            int columnIndex = fieldIndex;
            int i = 0;
            while (i < values.size()) {
                if (!Objects.equals(values.get(i), "")) {
                    sql = String.format("%s%s%s%s", sql, " AND v", columnIndex, " = ?");
                }
                ++i;
                ++columnIndex;
            }
            try (PreparedStatement ps = this.conn.prepareStatement(sql);){
                ps.setString(1, ptype);
                int index = 2;
                for (String value : values) {
                    if (Objects.equals(value, "")) continue;
                    ps.setString(index++, value);
                }
                int rows = ps.executeUpdate();
                if (rows < 1 && this.removePolicyFailed) {
                    throw new CasbinAdapterException(String.format("Remove filtered policy error, remove %d rows, expect least 1 rows", rows));
                }
            }
        });
    }

    public void updatePolicy(String sec, String ptype, List<String> oldRule, List<String> newRule) {
        if (CollectionUtils.isEmpty(oldRule) || CollectionUtils.isEmpty(newRule)) {
            return;
        }
        String sql = this.renderActualSql("INSERT INTO casbin_rule (ptype,v0,v1,v2,v3,v4,v5) VALUES(?,?,?,?,?,?,?)");
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            this.conn.setAutoCommit(false);
            this.removePolicy(sec, ptype, oldRule);
            try (PreparedStatement ps = this.conn.prepareStatement(sql);){
                CasbinRule line = this.savePolicyLine(ptype, newRule);
                ps.setString(1, line.ptype);
                ps.setString(2, line.v0);
                ps.setString(3, line.v1);
                ps.setString(4, line.v2);
                ps.setString(5, line.v3);
                ps.setString(6, line.v4);
                ps.setString(7, line.v5);
                ps.executeUpdate();
                this.conn.commit();
            }
            catch (SQLException e) {
                this.conn.rollback();
                e.printStackTrace();
                throw e;
            }
            finally {
                this.conn.setAutoCommit(true);
            }
        });
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    protected void retry(ExecutionContext<Void> ctx) throws SQLException {
        if (ctx.getExecutionCount() >= 3) {
            throw new Error(ctx.getLastFailure());
        }
        this.conn = this.dataSource.getConnection();
    }

    protected String renderActualSql(String sql) {
        return sql.replace(DEFAULT_TABLE_NAME, this.tableName);
    }
}

